/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsObsolescence;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteStatisticsInMemoryStoreImpl
implements IgniteStatisticsStore {
    private final Map<StatisticsKey, IntMap<ObjectPartitionStatisticsImpl>> partsStats = new ConcurrentHashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsImpl>>();
    private final Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> obsStats = new ConcurrentHashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>>();
    private final IgniteLogger log;

    public IgniteStatisticsInMemoryStoreImpl(Function<Class<?>, IgniteLogger> logSupplier) {
        this.log = logSupplier.apply(IgniteStatisticsInMemoryStoreImpl.class);
    }

    @Override
    public void clearAllStatistics() {
        this.partsStats.clear();
        this.obsStats.clear();
    }

    @Override
    public Map<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> getAllLocalPartitionsStatistics(String schema) {
        HashMap<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>> res = new HashMap<StatisticsKey, Collection<ObjectPartitionStatisticsImpl>>(this.partsStats.size());
        for (StatisticsKey key : this.partsStats.keySet()) {
            this.partsStats.computeIfPresent(key, (k, v) -> {
                res.put((StatisticsKey)k, v.values());
                return v;
            });
        }
        return res;
    }

    @Override
    public void replaceLocalPartitionsStatistics(StatisticsKey key, Collection<ObjectPartitionStatisticsImpl> statistics) {
        this.partsStats.put(key, this.buildStatisticsMap(key, statistics));
    }

    @Override
    public Collection<ObjectPartitionStatisticsImpl> getLocalPartitionsStatistics(StatisticsKey key) {
        Collection[] res = new Collection[1];
        this.partsStats.computeIfPresent(key, (k, v) -> {
            res[0] = new ArrayList(v.values());
            return v;
        });
        return res[0] == null ? Collections.emptyList() : res[0];
    }

    @Override
    public void clearLocalPartitionsStatistics(StatisticsKey key) {
        this.partsStats.remove(key);
    }

    @Override
    public void saveLocalPartitionStatistics(StatisticsKey key, ObjectPartitionStatisticsImpl statistics) {
        this.partsStats.compute(key, (k, v) -> {
            if (v == null) {
                v = new IntHashMap<ObjectPartitionStatisticsImpl>();
            }
            v.put(statistics.partId(), statistics);
            return v;
        });
    }

    @Override
    public void saveObsolescenceInfo(Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> obsolescence) {
        for (Map.Entry<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> objObs : obsolescence.entrySet()) {
            this.obsStats.compute(objObs.getKey(), (k, v) -> {
                if (v == null) {
                    v = new IntHashMap();
                }
                IntHashMap vFinal = v;
                ((IntMap)objObs.getValue()).forEach((k1, v1) -> vFinal.put(k1, v1));
                return v;
            });
        }
    }

    @Override
    public void saveObsolescenceInfo(StatisticsKey key, int partId, ObjectPartitionStatisticsObsolescence partObs) {
        this.obsStats.compute(key, (k, v) -> {
            if (v == null) {
                v = new IntHashMap<ObjectPartitionStatisticsObsolescence>();
            }
            v.put(partId, partObs);
            return v;
        });
    }

    @Override
    public void clearObsolescenceInfo(StatisticsKey key, Collection<Integer> partIds) {
        if (F.isEmpty(partIds)) {
            this.obsStats.remove(key);
        } else {
            this.obsStats.computeIfPresent(key, (k, v) -> {
                for (Integer partId : partIds) {
                    v.remove(partId);
                }
                return v.isEmpty() ? null : v;
            });
        }
    }

    @Override
    public Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> loadAllObsolescence() {
        HashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> res = new HashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>>();
        this.obsStats.forEach((k, v) -> {
            IntHashMap newV = new IntHashMap(v.size());
            v.forEach((k1, v1) -> newV.put(k1, v1));
            res.put((StatisticsKey)k, newV);
        });
        return res;
    }

    @Override
    public ObjectPartitionStatisticsImpl getLocalPartitionStatistics(StatisticsKey key, int partId) {
        ObjectPartitionStatisticsImpl[] res = new ObjectPartitionStatisticsImpl[1];
        this.partsStats.computeIfPresent(key, (k, v) -> {
            res[0] = (ObjectPartitionStatisticsImpl)v.get(partId);
            return v;
        });
        return res[0];
    }

    @Override
    public void clearLocalPartitionStatistics(StatisticsKey key, int partId) {
        this.partsStats.computeIfPresent(key, (k, v) -> {
            v.remove(partId);
            return v;
        });
    }

    @Override
    public void clearLocalPartitionsStatistics(StatisticsKey key, Collection<Integer> partIds) {
        this.partsStats.computeIfPresent(key, (k, v) -> {
            for (Integer partId : partIds) {
                v.remove(partId);
            }
            return v;
        });
    }

    private IntMap<ObjectPartitionStatisticsImpl> buildStatisticsMap(StatisticsKey key, Collection<ObjectPartitionStatisticsImpl> statistics) {
        IntHashMap<ObjectPartitionStatisticsImpl> statisticsMap = new IntHashMap<ObjectPartitionStatisticsImpl>();
        for (ObjectPartitionStatisticsImpl s : statistics) {
            if (statisticsMap.put(s.partId(), s) == null) continue;
            this.log.warning(String.format("Trying to save more than one %s.%s partition statistics for partition %d", key.schema(), key.obj(), s.partId()));
        }
        return statisticsMap;
    }

    @Override
    public Collection<Integer> loadLocalPartitionMap(StatisticsKey key) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        this.partsStats.computeIfPresent(key, (k, v) -> {
            int[] nArray = v.keys();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer partId = nArray[i];
                res.add(partId);
            }
            return v;
        });
        return res;
    }
}

