/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.events;

import org.apache.ignite.Ignite;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformLocalEventListener
implements IgnitePredicate<Event> {
    private static final long serialVersionUID = 0L;
    private final int id;
    @IgniteInstanceResource
    private transient Ignite ignite;

    public PlatformLocalEventListener(int id) {
        this.id = id;
    }

    @Override
    public boolean apply(Event evt) {
        assert (this.ignite != null);
        PlatformContext ctx = PlatformUtils.platformContext(this.ignite);
        assert (ctx != null);
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = ctx.writer(out);
            writer.writeInt(this.id);
            ctx.writeEvent(writer, evt);
            out.synchronize();
            long res = ctx.gateway().eventLocalListenerApply(mem.pointer());
            boolean bl = res != 0L;
            return bl;
        }
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.id == ((PlatformLocalEventListener)o).id;
    }

    public int hashCode() {
        return this.id;
    }
}

