/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.jetbrains.annotations.Nullable;

public class ClientAtomicLongCreateRequest
extends ClientRequest {
    private final String name;
    private final long initVal;
    private final AtomicConfiguration atomicConfiguration;

    public ClientAtomicLongCreateRequest(BinaryRawReader reader) {
        super(reader);
        this.name = reader.readString();
        this.initVal = reader.readLong();
        this.atomicConfiguration = ClientAtomicLongCreateRequest.readAtomicConfiguration(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            ctx.kernalContext().dataStructures().atomicLong(this.name, this.atomicConfiguration, this.initVal, true);
            return new ClientResponse(this.requestId());
        }
        catch (IgniteCheckedException e) {
            return new ClientResponse(this.requestId(), e.getMessage());
        }
    }

    @Nullable
    private static AtomicConfiguration readAtomicConfiguration(BinaryRawReader reader) {
        if (!reader.readBoolean()) {
            return null;
        }
        return new AtomicConfiguration().setAtomicSequenceReserveSize(reader.readInt()).setCacheMode(CacheMode.fromCode(reader.readByte())).setBackups(reader.readInt()).setGroupName(reader.readString());
    }
}

