/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class ClientListenerProtocolVersion
implements Comparable<ClientListenerProtocolVersion> {
    private final short major;
    private final short minor;
    private final short maintenance;

    public static ClientListenerProtocolVersion create(int major, int minor, int maintenance) {
        return new ClientListenerProtocolVersion((short)major, (short)minor, (short)maintenance);
    }

    private ClientListenerProtocolVersion(short major, short minor, short maintenance) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
    }

    public short major() {
        return this.major;
    }

    public short minor() {
        return this.minor;
    }

    public short maintenance() {
        return this.maintenance;
    }

    public String asString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.maintenance;
    }

    @Override
    public int compareTo(@NotNull ClientListenerProtocolVersion other) {
        int res = this.major - other.major;
        if (res == 0) {
            res = this.minor - other.minor;
        }
        if (res == 0) {
            res = this.maintenance - other.maintenance;
        }
        return res;
    }

    public int hashCode() {
        return 31 * (31 * this.major + this.minor) + this.maintenance;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ClientListenerProtocolVersion) {
            ClientListenerProtocolVersion other = (ClientListenerProtocolVersion)obj;
            return F.eq(this.major, other.major) && F.eq(this.minor, other.minor) && F.eq(this.maintenance, other.maintenance);
        }
        return false;
    }

    public String toString() {
        return S.toString(ClientListenerProtocolVersion.class, this);
    }
}

