/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.jetbrains.annotations.NotNull;

public class ByteBufferBackedDataInputImpl
implements ByteBufferBackedDataInput {
    private ByteBuffer buf;

    public ByteBufferBackedDataInput buffer(ByteBuffer buf) {
        this.buf = buf;
        return this;
    }

    @Override
    public ByteBuffer buffer() {
        return this.buf;
    }

    @Override
    public void ensure(int requested) throws IOException {
        if (this.buf.remaining() < requested) {
            throw new IOException("Requested size is greater than buffer: " + requested);
        }
    }

    @Override
    public void readFully(@NotNull byte[] b) throws IOException {
        this.ensure(b.length);
        this.buf.get(b);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        this.ensure(b.length);
        this.buf.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.ensure(n);
        this.buf.position(this.buf.position() + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensure(1);
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.ensure(2);
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensure(2);
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.ensure(4);
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensure(8);
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensure(4);
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensure(8);
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

