/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.dump.DumpEntry;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.management.cache.IdleVerifyResultV2;
import org.apache.ignite.internal.management.cache.PartitionKeyV2;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.Dump;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class SnapshotPartitionsVerifyHandler
implements SnapshotHandler<Map<PartitionKeyV2, PartitionHashRecordV2>> {
    protected final GridCacheSharedContext<?, ?> cctx;
    private final IgniteLogger log;

    public SnapshotPartitionsVerifyHandler(GridCacheSharedContext<?, ?> cctx) {
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public SnapshotHandlerType type() {
        return SnapshotHandlerType.RESTORE;
    }

    @Override
    public Map<PartitionKeyV2, PartitionHashRecordV2> invoke(SnapshotHandlerContext opCtx) throws IgniteCheckedException {
        Set<Integer> grps;
        if (!opCtx.snapshotDirectory().exists()) {
            throw new IgniteCheckedException("Snapshot directory doesn't exists: " + opCtx.snapshotDirectory());
        }
        SnapshotMetadata meta = opCtx.metadata();
        Set<Integer> set = grps = F.isEmpty(opCtx.groups()) ? new HashSet<Integer>(meta.partitions().keySet()) : opCtx.groups().stream().map(GridCacheUtils::cacheId).collect(Collectors.toSet());
        if (this.type() == SnapshotHandlerType.CREATE) {
            grps = grps.stream().filter(grp -> grp == MetaStorage.METASTORAGE_CACHE_ID || CU.affinityNode(this.cctx.localNode(), this.cctx.kernalContext().cache().cacheGroupDescriptor((int)grp).config().getNodeFilter())).collect(Collectors.toSet());
        }
        HashSet<File> partFiles = new HashSet<File>();
        HashMap<Integer, File> grpDirs = new HashMap<Integer, File>();
        for (File dir : FilePageStoreManager.cacheDirectories(new File(opCtx.snapshotDirectory(), IgniteSnapshotManager.databaseRelativePath(meta.folderName())), name -> true)) {
            int grpId = CU.cacheId(FilePageStoreManager.cacheGroupName(dir));
            if (!grps.remove(grpId)) continue;
            HashSet parts = meta.partitions().get(grpId) == null ? Collections.emptySet() : new HashSet(meta.partitions().get(grpId));
            for (File part : FilePageStoreManager.cachePartitionFiles(dir, (meta.dump() ? ".dump" : ".bin") + (meta.compressPartitions() ? ".zip" : ""))) {
                int partId = FilePageStoreManager.partId(part.getName());
                if (!parts.remove(partId)) continue;
                partFiles.add(part);
            }
            if (!parts.isEmpty()) {
                throw new IgniteException("Snapshot data doesn't contain required cache group partition [grpId=" + grpId + ", snpName=" + meta.snapshotName() + ", consId=" + meta.consistentId() + ", missed=" + parts + ", meta=" + meta + "]");
            }
            grpDirs.put(grpId, dir);
        }
        if (!grps.isEmpty()) {
            throw new IgniteException("Snapshot data doesn't contain required cache groups [grps=" + grps + ", snpName=" + meta.snapshotName() + ", consId=" + meta.consistentId() + ", meta=" + meta + "]");
        }
        if (!opCtx.check()) {
            this.log.info("Snapshot data integrity check skipped [snpName=" + meta.snapshotName() + "]");
            return Collections.emptyMap();
        }
        return meta.dump() ? this.checkDumpFiles(opCtx, partFiles) : this.checkSnapshotFiles(opCtx, grpDirs, meta, partFiles, this.isPunchHoleEnabled(opCtx, grpDirs.keySet()));
    }

    private Map<PartitionKeyV2, PartitionHashRecordV2> checkSnapshotFiles(SnapshotHandlerContext opCtx, Map<Integer, File> grpDirs, SnapshotMetadata meta, Set<File> partFiles, boolean punchHoleEnabled) throws IgniteCheckedException {
        ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2> res = new ConcurrentHashMap<PartitionKeyV2, PartitionHashRecordV2>();
        ThreadLocal<ByteBuffer> buff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(meta.pageSize()).order(ByteOrder.nativeOrder()));
        IgniteSnapshotManager snpMgr = this.cctx.snapshotMgr();
        StandaloneGridKernalContext snpCtx = snpMgr.createStandaloneKernalContext(this.cctx.kernalContext().compress(), opCtx.snapshotDirectory(), meta.folderName());
        FilePageStoreManager storeMgr = (FilePageStoreManager)this.cctx.pageStore();
        SnapshotEncryptionKeyProvider snpEncrKeyProvider = new SnapshotEncryptionKeyProvider(this.cctx.kernalContext(), grpDirs);
        StandaloneGridKernalContext.startAllComponents(snpCtx);
        try {
            U.doInParallel(snpMgr.snapshotExecutorService(), partFiles, part -> {
                String grpName = FilePageStoreManager.cacheGroupName(part.getParentFile());
                int grpId = CU.cacheId(grpName);
                int partId = FilePageStoreManager.partId(part.getName());
                try (FilePageStore pageStore = (FilePageStore)storeMgr.getPageStoreFactory(grpId, snpEncrKeyProvider.getActiveKey(grpId) != null ? snpEncrKeyProvider : null).createPageStore(GroupPartitionId.getTypeByPartId(partId), part::toPath, val -> {});){
                    PagePartitionMetaIO io;
                    GridDhtPartitionState partState;
                    pageStore.init();
                    if (punchHoleEnabled && meta.isGroupWithCompression(grpId) && this.type() == SnapshotHandlerType.CREATE) {
                        byte pageType = partId == 65535 ? (byte)2 : (byte)1;
                        IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, partId, pageType, (id, buffer) -> {
                            if (PageIO.getCompressionType(buffer) == 0) {
                                return;
                            }
                            short comprPageSz = PageIO.getCompressedSize(buffer);
                            if (comprPageSz < pageStore.getPageSize()) {
                                try {
                                    pageStore.punchHole((long)id, comprPageSz);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    if (partId == 65535) {
                        if (!this.skipHash()) {
                            IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, 65535, (byte)2);
                        }
                        Object pageType = null;
                        return pageType;
                    }
                    if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
                        if (!this.skipHash()) {
                            IdleVerifyUtility.checkPartitionsPageCrcSum(() -> pageStore, partId, (byte)1);
                        }
                        Object pageType = null;
                        return pageType;
                    }
                    ByteBuffer pageBuff = (ByteBuffer)buff.get();
                    pageBuff.clear();
                    pageStore.read(0L, pageBuff, true);
                    long pageAddr = GridUnsafe.bufferAddress(pageBuff);
                    if (PageIO.getCompressionType(pageBuff) != 0) {
                        snpCtx.compress().decompressPage(pageBuff, pageStore.getPageSize());
                    }
                    if ((partState = GridDhtPartitionState.fromOrdinal((io = (PagePartitionMetaIO)PageIO.getPageIO(pageBuff)).getPartitionState(pageAddr))) != GridDhtPartitionState.OWNING) {
                        throw new IgniteCheckedException("Snapshot partitions must be in the OWNING state only: " + partState);
                    }
                    long updateCntr = io.getUpdateCounter(pageAddr);
                    long size = io.getSize(pageAddr);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition [grpId=" + grpId + ", id=" + partId + ", counter=" + updateCntr + ", size=" + size + "]");
                    }
                    PartitionKeyV2 key = new PartitionKeyV2(grpId, partId, grpName);
                    PartitionHashRecordV2 hash = IdleVerifyUtility.calculatePartitionHash(key, updateCntr, meta.consistentId(), GridDhtPartitionState.OWNING, false, size, this.skipHash() ? F.emptyIterator() : snpMgr.partitionRowIterator(snpCtx, grpName, partId, pageStore));
                    assert (hash != null) : "OWNING must have hash: " + key;
                    if (this.hasExpiringEntries(snpCtx, pageStore, pageBuff, io.getPendingTreeRoot(pageAddr))) {
                        hash.hasExpiringEntries(true);
                    }
                    res.put(key, hash);
                    return null;
                }
                catch (IOException e) {
                    throw new IgniteCheckedException(e);
                }
            });
        }
        catch (Throwable t) {
            this.log.error("Error executing handler: ", t);
            throw t;
        }
        finally {
            StandaloneGridKernalContext.closeAllComponents(snpCtx);
        }
        return res;
    }

    private boolean hasExpiringEntries(GridKernalContext ctx, PageStore pageStore, ByteBuffer pageBuff, long pendingTreeMetaId) throws IgniteCheckedException {
        BPlusIO rootIO;
        if (pendingTreeMetaId == 0L) {
            return false;
        }
        long pageAddr = GridUnsafe.bufferAddress(pageBuff);
        pageBuff.clear();
        pageStore.read(pendingTreeMetaId, pageBuff, true);
        if (PageIO.getCompressionType(pageBuff) != 0) {
            ctx.compress().decompressPage(pageBuff, pageStore.getPageSize());
        }
        BPlusMetaIO treeIO = BPlusMetaIO.VERSIONS.forPage(pageAddr);
        int rootLvl = treeIO.getRootLevel(pageAddr);
        long rootId = treeIO.getFirstPageId(pageAddr, rootLvl);
        pageBuff.clear();
        pageStore.read(rootId, pageBuff, true);
        if (PageIO.getCompressionType(pageBuff) != 0) {
            ctx.compress().decompressPage(pageBuff, pageStore.getPageSize());
        }
        return (rootIO = (BPlusIO)PageIO.getPageIO(pageBuff)).getCount(pageAddr) != 0;
    }

    private Map<PartitionKeyV2, PartitionHashRecordV2> checkDumpFiles(SnapshotHandlerContext opCtx, Set<File> partFiles) {
        Map<PartitionKeyV2, PartitionHashRecordV2> map;
        String consistentId = this.cctx.kernalContext().pdsFolderResolver().resolveFolders().consistentId().toString();
        EncryptionSpi encSpi = opCtx.metadata().encryptionKey() != null ? this.cctx.gridConfig().getEncryptionSpi() : null;
        Dump dump = new Dump(opCtx.snapshotDirectory(), consistentId, true, true, encSpi, this.log);
        try {
            Collection<PartitionHashRecordV2> partitionHashRecordV2s = U.doInParallel(this.cctx.snapshotMgr().snapshotExecutorService(), partFiles, part -> this.calculateDumpedPartitionHash(dump, FilePageStoreManager.cacheGroupName(part.getParentFile()), FilePageStoreManager.partId(part.getName())));
            map = partitionHashRecordV2s.stream().collect(Collectors.toMap(PartitionHashRecordV2::partitionKey, r -> r));
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        dump.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.log.error("Error executing handler: ", t);
                    throw new IgniteException(t);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        dump.close();
        return map;
    }

    private PartitionHashRecordV2 calculateDumpedPartitionHash(Dump dump, String grpName, int part) {
        PartitionHashRecordV2 partitionHashRecordV2;
        block10: {
            if (this.skipHash()) {
                return new PartitionHashRecordV2(new PartitionKeyV2(CU.cacheId(grpName), part, grpName), false, this.cctx.localNode().consistentId(), null, 0L, PartitionHashRecordV2.PartitionState.OWNING, new IdleVerifyUtility.VerifyPartitionContext());
            }
            String node = this.cctx.kernalContext().pdsFolderResolver().resolveFolders().folderName();
            Dump.DumpedPartitionIterator iter = dump.iterator(node, CU.cacheId(grpName), part);
            try {
                long size = 0L;
                IdleVerifyUtility.VerifyPartitionContext ctx = new IdleVerifyUtility.VerifyPartitionContext();
                while (iter.hasNext()) {
                    DumpEntry e = (DumpEntry)iter.next();
                    ctx.update((KeyCacheObject)e.key(), (CacheObject)e.value(), e.version());
                    ++size;
                }
                partitionHashRecordV2 = new PartitionHashRecordV2(new PartitionKeyV2(CU.cacheId(grpName), part, grpName), false, this.cctx.localNode().consistentId(), null, size, PartitionHashRecordV2.PartitionState.OWNING, ctx);
                if (iter == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (iter != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteException(e);
                }
            }
            iter.close();
        }
        return partitionHashRecordV2;
    }

    @Override
    public void complete(String name, Collection<SnapshotHandlerResult<Map<PartitionKeyV2, PartitionHashRecordV2>>> results) throws IgniteCheckedException {
        HashMap<PartitionKeyV2, List<PartitionHashRecordV2>> clusterHashes = new HashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        HashMap<ClusterNode, Exception> errs = new HashMap<ClusterNode, Exception>();
        for (SnapshotHandlerResult<Map<PartitionKeyV2, PartitionHashRecordV2>> res : results) {
            if (res.error() != null) {
                errs.put(res.node(), res.error());
                continue;
            }
            for (Map.Entry<PartitionKeyV2, PartitionHashRecordV2> entry : res.data().entrySet()) {
                clusterHashes.computeIfAbsent(entry.getKey(), v -> new ArrayList()).add(entry.getValue());
            }
        }
        IdleVerifyResultV2 verifyResult = new IdleVerifyResultV2(clusterHashes, errs);
        if (errs.isEmpty() && !verifyResult.hasConflicts()) {
            return;
        }
        GridStringBuilder buf = new GridStringBuilder();
        verifyResult.print(buf::a, true);
        throw new IgniteCheckedException(buf.toString());
    }

    protected boolean skipHash() {
        return false;
    }

    protected boolean isPunchHoleEnabled(SnapshotHandlerContext opCtx, Set<Integer> grpIds) {
        SnapshotMetadata meta = opCtx.metadata();
        Path snapshotDir = opCtx.snapshotDirectory().toPath();
        if (meta.hasCompressedGroups()) {
            if (grpIds.stream().anyMatch(meta::isGroupWithCompression)) {
                try {
                    this.cctx.kernalContext().compress().checkPageCompressionSupported(snapshotDir, meta.pageSize());
                    return true;
                }
                catch (Exception e) {
                    this.log.info("File system doesn't support page compression on snapshot directory: " + snapshotDir + ", snapshot may have larger size than expected.");
                }
            }
        }
        return false;
    }

    private static class SnapshotEncryptionKeyProvider
    implements EncryptionCacheKeyProvider {
        private final GridKernalContext ctx;
        private final Map<Integer, File> grpDirs;
        private final ConcurrentHashMap<Integer, GroupKey> decryptedKeys = new ConcurrentHashMap();

        private SnapshotEncryptionKeyProvider(GridKernalContext ctx, Map<Integer, File> grpDirs) {
            this.ctx = ctx;
            this.grpDirs = grpDirs;
        }

        @Override
        @Nullable
        public GroupKey getActiveKey(int grpId) {
            return this.decryptedKeys.computeIfAbsent(grpId, id -> {
                GroupKey grpKey = null;
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.grpDirs.get(grpId).toPath(), p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith("cache_data.dat"));){
                    for (Path p2 : ds) {
                        StoredCacheData cacheData = this.ctx.cache().configManager().readCacheData(p2.toFile());
                        GroupKeyEncrypted grpKeyEncrypted = cacheData.groupKeyEncrypted();
                        if (grpKeyEncrypted == null) {
                            GroupKey groupKey = null;
                            return groupKey;
                        }
                        if (grpKey == null) {
                            grpKey = new GroupKey(grpKeyEncrypted.id(), this.ctx.config().getEncryptionSpi().decryptKey(grpKeyEncrypted.key()));
                            continue;
                        }
                        assert (grpKey.equals(new GroupKey(grpKeyEncrypted.id(), this.ctx.config().getEncryptionSpi().decryptKey(grpKeyEncrypted.key()))));
                    }
                    Iterator<Path> iterator = grpKey;
                    return iterator;
                }
                catch (Exception e) {
                    throw new IgniteException("Unable to extract ciphered encryption key of cache group " + id + ".", e);
                }
            });
        }

        @Override
        @Nullable
        public GroupKey groupKey(int grpId, int keyId) {
            GroupKey key = this.getActiveKey(grpId);
            return key != null && key.id() == keyId ? key : null;
        }
    }
}

