/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.CachePartitionDefragmentationManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentation;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.DefragmentationParameters;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;

public class IgniteDefragmentationImpl
implements IgniteDefragmentation {
    private final GridKernalContext ctx;

    public IgniteDefragmentationImpl(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public IgniteDefragmentation.ScheduleResult schedule(List<String> cacheNames) throws IgniteCheckedException {
        MaintenanceTask oldTask;
        MaintenanceRegistry maintenanceRegistry = this.ctx.maintenanceRegistry();
        try {
            oldTask = maintenanceRegistry.registerMaintenanceTask(DefragmentationParameters.toStore(cacheNames != null ? cacheNames : Collections.emptyList()));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Scheduling failed: " + e.getMessage());
        }
        return oldTask != null ? IgniteDefragmentation.ScheduleResult.SUCCESS_SUPERSEDED_PREVIOUS : IgniteDefragmentation.ScheduleResult.SUCCESS;
    }

    @Override
    public IgniteDefragmentation.CancelResult cancel() throws IgniteCheckedException {
        List<MaintenanceAction<?>> actions;
        MaintenanceRegistry maintenanceRegistry = this.ctx.maintenanceRegistry();
        if (!maintenanceRegistry.isMaintenanceMode()) {
            boolean deleted = maintenanceRegistry.unregisterMaintenanceTask("defragmentationMaintenanceTask");
            return deleted ? IgniteDefragmentation.CancelResult.CANCELLED_SCHEDULED : IgniteDefragmentation.CancelResult.SCHEDULED_NOT_FOUND;
        }
        try {
            actions = maintenanceRegistry.actionsForMaintenanceTask("defragmentationMaintenanceTask");
        }
        catch (IgniteException e) {
            return IgniteDefragmentation.CancelResult.COMPLETED_OR_CANCELLED;
        }
        Optional<MaintenanceAction> stopAct = actions.stream().filter(a -> "stop".equals(a.name())).findAny();
        assert (stopAct.isPresent());
        try {
            Object res = stopAct.get().execute();
            assert (res instanceof Boolean);
            boolean cancelled = (Boolean)res;
            return cancelled ? IgniteDefragmentation.CancelResult.CANCELLED : IgniteDefragmentation.CancelResult.COMPLETED_OR_CANCELLED;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Exception occurred: " + e.getMessage(), e);
        }
    }

    @Override
    public IgniteDefragmentation.DefragmentationStatus status() throws IgniteCheckedException {
        MaintenanceRegistry maintenanceRegistry = this.ctx.maintenanceRegistry();
        if (!maintenanceRegistry.isMaintenanceMode()) {
            throw new IgniteCheckedException("Node is not in maintenance mode.");
        }
        IgniteCacheDatabaseSharedManager dbMgr = this.ctx.cache().context().database();
        assert (dbMgr instanceof GridCacheDatabaseSharedManager);
        CachePartitionDefragmentationManager defrgMgr = ((GridCacheDatabaseSharedManager)dbMgr).defragmentationManager();
        if (defrgMgr == null) {
            throw new IgniteCheckedException("There's no active defragmentation process on the node.");
        }
        CachePartitionDefragmentationManager.Status status = defrgMgr.status();
        long startTs = status.getStartTs();
        long finishTs = status.getFinishTs();
        long elapsedTime = finishTs != 0L ? finishTs - startTs : System.currentTimeMillis() - startTs;
        HashMap<String, IgniteDefragmentation.CompletedDefragmentationInfo> completedCaches = new HashMap<String, IgniteDefragmentation.CompletedDefragmentationInfo>();
        HashMap<String, IgniteDefragmentation.InProgressDefragmentationInfo> progressCaches = new HashMap<String, IgniteDefragmentation.InProgressDefragmentationInfo>();
        status.getFinishedGroups().forEach((context, progress) -> {
            String name = context.cacheOrGroupName();
            long oldSize = progress.getOldSize();
            long newSize = progress.getNewSize();
            long cgElapsedTime = progress.getFinishTs() - progress.getStartTs();
            IgniteDefragmentation.CompletedDefragmentationInfo info = new IgniteDefragmentation.CompletedDefragmentationInfo(cgElapsedTime, oldSize, newSize);
            completedCaches.put(name, info);
        });
        status.getProgressGroups().forEach((context, progress) -> {
            String name = context.cacheOrGroupName();
            long cgElapsedTime = System.currentTimeMillis() - progress.getStartTs();
            int partsTotal = progress.getPartsTotal();
            int partsCompleted = progress.getPartsCompleted();
            IgniteDefragmentation.InProgressDefragmentationInfo info = new IgniteDefragmentation.InProgressDefragmentationInfo(cgElapsedTime, partsCompleted, partsTotal);
            progressCaches.put(name, info);
        });
        return new IgniteDefragmentation.DefragmentationStatus(completedCaches, progressCaches, status.getScheduledGroups(), status.getSkippedGroups(), status.getTotalPartitionCount(), status.getDefragmentedPartitionCount(), startTs, elapsedTime);
    }

    @Override
    public boolean inProgress() {
        CachePartitionDefragmentationManager.Status status = this.getStatus();
        return status != null && status.getFinishTs() == 0L;
    }

    @Override
    public int processedPartitions() {
        CachePartitionDefragmentationManager.Status status = this.getStatus();
        if (status == null) {
            return 0;
        }
        return status.getDefragmentedPartitionCount();
    }

    @Override
    public int totalPartitions() {
        CachePartitionDefragmentationManager.Status status = this.getStatus();
        if (status == null) {
            return 0;
        }
        return status.getTotalPartitionCount();
    }

    @Override
    public long startTime() {
        CachePartitionDefragmentationManager.Status status = this.getStatus();
        if (status == null) {
            return 0L;
        }
        return status.getStartTs();
    }

    private CachePartitionDefragmentationManager.Status getStatus() {
        MaintenanceRegistry maintenanceRegistry = this.ctx.maintenanceRegistry();
        if (!maintenanceRegistry.isMaintenanceMode()) {
            return null;
        }
        IgniteCacheDatabaseSharedManager dbMgr = this.ctx.cache().context().database();
        assert (dbMgr instanceof GridCacheDatabaseSharedManager);
        CachePartitionDefragmentationManager defrgMgr = ((GridCacheDatabaseSharedManager)dbMgr).defragmentationManager();
        if (defrgMgr == null) {
            return null;
        }
        return defrgMgr.status();
    }
}

