/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.api;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.IgniteCommandRegistry;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.CommandsRegistry;

public abstract class CommandRegistryImpl<A extends IgniteDataTransferObject, R>
implements CommandsRegistry<A, R> {
    private final Map<String, Command<?, ?>> commands = new LinkedHashMap();

    protected CommandRegistryImpl(Command<?, ?> ... subcommands) {
        for (Command<?, ?> cmd : subcommands) {
            this.register(cmd);
        }
    }

    protected void register(Command<?, ?> cmd) {
        boolean hasParent = CommandsRegistry.class.isAssignableFrom(this.getClass()) && this.getClass() != IgniteCommandRegistry.class;
        String key = CommandUtils.cmdKey(cmd.getClass(), hasParent ? this.getClass() : null);
        if (this.commands.containsKey(key)) {
            throw new IllegalArgumentException("Command already registered");
        }
        this.commands.put(key, cmd);
    }

    @Override
    public Command<?, ?> command(String name) {
        return this.commands.get(name);
    }

    @Override
    public Iterator<Map.Entry<String, Command<?, ?>>> commands() {
        return this.commands.entrySet().iterator();
    }
}

