/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventLocalOrder;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class EventAdapter
implements Event {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final long tstamp = U.currentTimeMillis();
    private ClusterNode node;
    private String msg;
    private int type;
    private long locId = EventLocalOrder.nextOrder();

    public EventAdapter() {
    }

    public EventAdapter(ClusterNode node, String msg, int type) {
        assert (this.tstamp > 0L);
        A.ensure(type > 0, "Event type ID must be greater than zero.");
        this.node = node;
        this.msg = msg;
        this.type = type;
    }

    @Override
    public int compareTo(Event o) {
        return o == null ? 1 : this.id.compareTo(o.id());
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    public long localOrder() {
        return this.locId;
    }

    public boolean equals(Object o) {
        assert (this.id != null);
        return this == o || o instanceof EventAdapter && this.id.equals(((Event)o).id());
    }

    public int hashCode() {
        assert (this.id != null);
        return this.id.hashCode();
    }

    public void node(ClusterNode node) {
        this.node = node;
    }

    public void message(@Nullable String msg) {
        this.msg = msg;
    }

    public void type(int type) {
        this.type = type;
    }

    @Override
    public ClusterNode node() {
        return this.node;
    }

    @Override
    @Nullable
    public String message() {
        return this.msg;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public long timestamp() {
        return this.tstamp;
    }

    @Override
    public String name() {
        return U.gridEventName(this.type());
    }

    @Override
    public String shortDisplay() {
        return this.toString();
    }

    public String toString() {
        return S.toString(EventAdapter.class, this, "name", (Object)this.name());
    }
}

