/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.slf4j;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jLogger
implements IgniteLogger {
    private final Logger impl;
    private final boolean quiet;

    public Slf4jLogger() {
        this(LoggerFactory.getLogger((String)"ROOT"));
    }

    public Slf4jLogger(Logger impl) {
        assert (impl != null);
        this.impl = impl;
        this.quiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "true"));
    }

    public Slf4jLogger getLogger(Object ctgr) {
        Logger impl = ctgr == null ? LoggerFactory.getLogger((String)"ROOT") : (ctgr instanceof Class ? LoggerFactory.getLogger((String)((Class)ctgr).getName()) : LoggerFactory.getLogger((String)ctgr.toString()));
        return new Slf4jLogger(impl);
    }

    public void trace(String msg) {
        this.trace(null, msg);
    }

    public void trace(@Nullable String marker, String msg) {
        if (!this.impl.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace(this.getMarkerOrNull(marker), msg);
    }

    public void debug(String msg) {
        this.debug(null, msg);
    }

    public void debug(@Nullable String marker, String msg) {
        if (!this.impl.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug(this.getMarkerOrNull(marker), msg);
    }

    public void info(String msg) {
        this.info(null, msg);
    }

    public void info(@Nullable String marker, String msg) {
        if (!this.impl.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info(this.getMarkerOrNull(marker), msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.warning(null, msg, e);
    }

    public void warning(@Nullable String marker, String msg, @Nullable Throwable e) {
        this.impl.warn(this.getMarkerOrNull(marker), msg, e);
    }

    public void error(String msg, @Nullable Throwable e) {
        this.error(null, msg, e);
    }

    public void error(@Nullable String marker, String msg, @Nullable Throwable e) {
        this.impl.error(this.getMarkerOrNull(marker), msg, e);
    }

    private Marker getMarkerOrNull(@Nullable String marker) {
        return marker != null ? MarkerFactory.getMarker((String)marker) : null;
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @Nullable
    public String fileName() {
        return null;
    }

    public String toString() {
        return S.toString(Slf4jLogger.class, (Object)this);
    }
}

