/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.io.Serializable;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelDataTypeFieldImpl
implements RelDataTypeField,
Serializable {
    private final RelDataType type;
    private final String name;
    private final int index;

    public RelDataTypeFieldImpl(String name, int index, RelDataType type) {
        this.name = Objects.requireNonNull(name, "name");
        this.index = index;
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.name, this.type);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelDataTypeFieldImpl)) {
            return false;
        }
        RelDataTypeFieldImpl that = (RelDataTypeFieldImpl)obj;
        return this.index == that.index && this.name.equals(that.name) && this.type.equals(that.type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public final String getKey() {
        return this.getName();
    }

    @Override
    public final RelDataType getValue() {
        return this.getType();
    }

    @Override
    public RelDataType setValue(RelDataType value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "#" + this.index + ": " + this.name + " " + this.type;
    }

    @Override
    public boolean isDynamicStar() {
        return this.type.getSqlTypeName() == SqlTypeName.DYNAMIC_STAR;
    }
}

