/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.calcite.sql.type.SqlTypeName;

public class IgniteMath {
    private static final BigDecimal UPPER_LONG_BIG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static final BigDecimal LOWER_LONG_BIG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    private static final Double UPPER_LONG_DOUBLE = 9.223372036854776E18;
    private static final Double LOWER_LONG_DOUBLE = -9.223372036854776E18;
    private static final Float UPPER_LONG_FLOAT = Float.valueOf(9.223372E18f);
    private static final Float LOWER_LONG_FLOAT = Float.valueOf(-9.223372E18f);
    private static final double LONG_MAX_EXT = 9.223372036854776E18;
    private static final double LONG_MIN_EXT = -9.223372036854776E18;
    private static final double INT_MAX_EXT = 2.147483648E9;
    private static final double INT_MIN_EXT = -2.147483649E9;
    private static final double SHORT_MAX_EXT = 32768.0;
    private static final double SHORT_MIN_EXT = -32769.0;
    private static final double BYTE_MAX_EXT = 128.0;
    private static final double BYTE_MIN_EXT = -129.0;
    public static final RoundingMode NUMERIC_ROUNDING_MODE = RoundingMode.HALF_UP;

    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException(SqlTypeName.BIGINT.getName() + " overflow");
        }
        return r;
    }

    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return r;
    }

    public static short addExact(short x, short y) {
        int r = x + y;
        if (r != (short)r) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return (short)r;
    }

    public static byte addExact(byte x, byte y) {
        int r = x + y;
        if (r != (byte)r) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return (byte)r;
    }

    public static long negateExact(long x) {
        long res = -x;
        if (x != 0L && x == res) {
            throw new ArithmeticException(SqlTypeName.BIGINT.getName() + " overflow");
        }
        return res;
    }

    public static int negateExact(int x) {
        int res = -x;
        if (x != 0 && x == res) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return res;
    }

    public static short negateExact(short x) {
        short res = -x;
        if (res > Short.MAX_VALUE) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return res;
    }

    public static byte negateExact(byte x) {
        byte res = -x;
        if (res > 127) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return res;
    }

    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw new ArithmeticException(SqlTypeName.BIGINT.getName() + " overflow");
        }
        return r;
    }

    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return r;
    }

    public static short subtractExact(short x, short y) {
        int r = x - y;
        if (r != (short)r) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return (short)r;
    }

    public static byte subtractExact(byte x, byte y) {
        int r = x - y;
        if (r != (byte)r) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return (byte)r;
    }

    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException(SqlTypeName.BIGINT.getName() + " overflow");
        }
        return r;
    }

    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        return IgniteMath.convertToIntExact(r);
    }

    public static short multiplyExact(short x, short y) {
        int r = x * y;
        if (r != (short)r) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return (short)r;
    }

    public static byte multiplyExact(byte x, byte y) {
        int r = x * y;
        if (r != (byte)r) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return (byte)r;
    }

    public static long divideExact(long x, long y) {
        if (y == -1L) {
            return IgniteMath.negateExact(x);
        }
        return x / y;
    }

    public static int divideExact(int x, int y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        return x / y;
    }

    public static short divideExact(short x, short y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        return (short)(x / y);
    }

    public static byte divideExact(byte x, byte y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        return (byte)(x / y);
    }

    public static long convertToLongExact(Number x) {
        x = IgniteMath.round(x);
        IgniteMath.checkNumberLongBounds(SqlTypeName.BIGINT, x);
        return x.longValue();
    }

    public static long convertToLongExact(double x) {
        if ((x = IgniteMath.extendToRound(x)) <= -9.223372036854776E18 || x >= 9.223372036854776E18) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return (long)x;
    }

    public static int convertToIntExact(long x) {
        int res = (int)x;
        if ((long)res != x) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return res;
    }

    public static int convertToIntExact(double x) {
        if ((x = IgniteMath.extendToRound(x)) <= -2.147483649E9 || x >= 2.147483648E9) {
            throw new ArithmeticException(SqlTypeName.INTEGER.getName() + " overflow");
        }
        return (int)x;
    }

    public static int convertToIntExact(Number x) {
        x = IgniteMath.round(x);
        IgniteMath.checkNumberLongBounds(SqlTypeName.INTEGER, x);
        return IgniteMath.convertToIntExact(x.longValue());
    }

    public static short convertToShortExact(long x) {
        short res = (short)x;
        if ((long)res != x) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return res;
    }

    public static short convertToShortExact(double x) {
        if ((x = IgniteMath.extendToRound(x)) <= -32769.0 || x >= 32768.0) {
            throw new ArithmeticException(SqlTypeName.SMALLINT.getName() + " overflow");
        }
        return (short)x;
    }

    public static short convertToShortExact(Number x) {
        x = IgniteMath.round(x);
        IgniteMath.checkNumberLongBounds(SqlTypeName.SMALLINT, x);
        return IgniteMath.convertToShortExact(x.longValue());
    }

    public static byte convertToByteExact(long x) {
        byte res = (byte)x;
        if ((long)res != x) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return res;
    }

    public static byte convertToByteExact(double x) {
        if ((x = IgniteMath.extendToRound(x)) <= -129.0 || x >= 128.0) {
            throw new ArithmeticException(SqlTypeName.TINYINT.getName() + " overflow");
        }
        return (byte)x;
    }

    public static byte convertToByteExact(Number x) {
        x = IgniteMath.round(x);
        IgniteMath.checkNumberLongBounds(SqlTypeName.TINYINT, x);
        return IgniteMath.convertToByteExact(x.longValue());
    }

    public static BigDecimal convertToBigDecimal(Number val) {
        BigDecimal dec = val instanceof Float ? BigDecimal.valueOf(val.floatValue()) : (val instanceof Double ? BigDecimal.valueOf(val.doubleValue()) : (val instanceof BigDecimal ? (BigDecimal)val : (val instanceof BigInteger ? new BigDecimal((BigInteger)val) : BigDecimal.valueOf(val.longValue()))));
        return dec;
    }

    private static void checkNumberLongBounds(SqlTypeName type, Number x) {
        if (x instanceof BigDecimal) {
            if (((BigDecimal)x).compareTo(UPPER_LONG_BIG_DECIMAL) < 0 && ((BigDecimal)x).compareTo(LOWER_LONG_BIG_DECIMAL) > 0) {
                return;
            }
        } else if (x instanceof Double) {
            if (((Double)x).compareTo(UPPER_LONG_DOUBLE) <= 0 && ((Double)x).compareTo(LOWER_LONG_DOUBLE) >= 0) {
                return;
            }
        } else if (x instanceof Float) {
            if (((Float)x).compareTo(UPPER_LONG_FLOAT) <= 0 && ((Float)x).compareTo(LOWER_LONG_FLOAT) >= 0) {
                return;
            }
        } else {
            return;
        }
        throw new ArithmeticException(type.getName() + " overflow");
    }

    private static double extendToRound(double x) {
        return x < 0.0 ? x - 0.5 : x + 0.5;
    }

    private static BigDecimal round(Number x) {
        return IgniteMath.convertToBigDecimal(x).setScale(0, NUMERIC_ROUNDING_MODE);
    }
}

