/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;

public class IgniteStatisticsImpl
implements Statistic {
    private static final int STATS_CLI_UPDATE_THRESHOLD = 200;
    AtomicInteger cliReqCnt = new AtomicInteger();
    private volatile long primaryRowCnt;
    private final ObjectStatisticsImpl statistics;
    private final CacheTableDescriptor desc;

    public IgniteStatisticsImpl(ObjectStatisticsImpl statistics) {
        this.statistics = statistics;
        this.desc = null;
    }

    public IgniteStatisticsImpl(CacheTableDescriptor desc) {
        this.statistics = null;
        this.desc = desc;
    }

    public Double getRowCount() {
        long rows = this.statistics != null ? this.statistics.rowCount() : (this.desc != null ? this.getRowCountApproximation() : 1000L);
        return rows;
    }

    public boolean isKey(ImmutableBitSet cols) {
        return false;
    }

    public List<ImmutableBitSet> getKeys() {
        return null;
    }

    public List<RelReferentialConstraint> getReferentialConstraints() {
        return ImmutableList.of();
    }

    public List<RelCollation> getCollations() {
        return ImmutableList.of();
    }

    public IgniteDistribution getDistribution() {
        return null;
    }

    public ColumnStatistics getColumnStatistics(String colName) {
        return this.statistics == null ? null : this.statistics.columnStatistics(colName);
    }

    private void refreshStatsIfNeededEx() {
        if (this.cliReqCnt.getAndIncrement() % 200 == 0) {
            try {
                this.primaryRowCnt = this.desc.cacheInfo().cacheContext().cache().sizeLong(new CachePeekMode[]{CachePeekMode.PRIMARY});
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
        }
    }

    private long getRowCountApproximation() {
        this.refreshStatsIfNeededEx();
        return this.primaryRowCnt;
    }
}

