/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.ViewTableMacroImpl;

public class IgniteSchema
extends AbstractSchema {
    private final String schemaName;
    private final Map<String, IgniteTable> tblMap = new ConcurrentHashMap<String, IgniteTable>();
    private final Multimap<String, Function> funcMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Map<String, String> viewMap = new ConcurrentHashMap<String, String>();

    public IgniteSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.schemaName;
    }

    protected Map<String, Table> getTableMap() {
        return Collections.unmodifiableMap(this.tblMap);
    }

    protected Multimap<String, Function> getFunctionMultimap() {
        return Multimaps.unmodifiableMultimap(this.funcMap);
    }

    public void addTable(String tblName, IgniteTable tbl) {
        this.tblMap.put(tblName, tbl);
    }

    public void removeTable(String tblName) {
        this.tblMap.remove(tblName);
    }

    public void addFunction(String name, Function func) {
        this.funcMap.put((Object)name, (Object)func);
    }

    public void addView(String name, String sql) {
        this.viewMap.put(name, sql);
    }

    public void removeView(String name) {
        this.viewMap.remove(name);
    }

    public SchemaPlus register(SchemaPlus parent) {
        SchemaPlus newSchema = parent.add(this.schemaName, (Schema)this);
        this.viewMap.forEach((name, sql) -> newSchema.add(name, (Function)new ViewTableMacroImpl((String)sql, newSchema)));
        return newSchema;
    }
}

