/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexCountScan;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexFirstLastScan;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class CacheIndexImpl
implements IgniteIndex {
    private final RelCollation collation;
    private final String idxName;
    @Nullable
    private final Index idx;
    private final IgniteCacheTable tbl;

    public CacheIndexImpl(RelCollation collation, String name, @Nullable Index idx, IgniteCacheTable tbl) {
        this.collation = collation;
        this.idxName = name;
        this.idx = idx;
        this.tbl = tbl;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    public String name() {
        return this.idxName;
    }

    @Override
    public IgniteTable table() {
        return this.tbl;
    }

    public Index queryIndex() {
        return this.idx;
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalIndexScan.create(cluster, cluster.traitSet(), relOptTbl, this.idxName, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup grp, RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        UUID locNodeId = execCtx.localNodeId();
        if (grp.nodeIds().contains(locNodeId) && this.idx != null) {
            return new IndexScan<Row>(execCtx, this.tbl.descriptor(), (InlineIndex)this.idx.unwrap(InlineIndex.class), this.collation.getKeys(), grp.partitions(locNodeId), ranges, requiredColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public <Row> Iterable<Row> firstOrLast(boolean first, ExecutionContext<Row> ectx, ColocationGroup grp, @Nullable ImmutableBitSet requiredColumns) {
        UUID locNodeId = ectx.localNodeId();
        if (grp.nodeIds().contains(locNodeId) && this.idx != null) {
            return new IndexFirstLastScan<Row>(first, ectx, this.tbl.descriptor(), (InlineIndexImpl)this.idx.unwrap(InlineIndexImpl.class), this.collation.getKeys(), grp.partitions(locNodeId), requiredColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public <Row> Iterable<Row> count(ExecutionContext<Row> ectx, ColocationGroup grp, boolean notNull) {
        if (this.idx == null || !grp.nodeIds().contains(ectx.localNodeId())) {
            return Collections.singletonList(ectx.rowHandler().factory(Long.TYPE).create(0L));
        }
        int[] locParts = grp.partitions(ectx.localNodeId());
        InlineIndex iidx = (InlineIndex)this.idx.unwrap(InlineIndex.class);
        return new IndexCountScan<Row>(ectx, this.tbl.descriptor().cacheContext(), locParts, iidx, this.collation, notNull);
    }

    @Override
    public List<SearchBounds> toSearchBounds(RelOptCluster cluster, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        RelCollation collation = this.collation;
        RelDataType rowType = this.tbl.getRowType(cluster.getTypeFactory());
        if (requiredColumns != null) {
            collation = (RelCollation)collation.apply(Commons.mapping(requiredColumns, rowType.getFieldCount()));
        }
        if (!collation.getFieldCollations().isEmpty()) {
            return RexUtils.buildSortedSearchBounds(cluster, collation, cond, rowType, requiredColumns);
        }
        return null;
    }

    @Override
    public boolean isInlineScanPossible(@Nullable ImmutableBitSet requiredColumns) {
        ImmutableIntList idxKeys;
        if (this.idx == null) {
            return false;
        }
        if (this.tbl.descriptor().cacheInfo() != null && !this.tbl.descriptor().cacheInfo().config().isEagerTtl()) {
            return false;
        }
        if (requiredColumns == null) {
            requiredColumns = ImmutableBitSet.range((int)this.tbl.descriptor().columnDescriptors().size());
        }
        if ((idxKeys = this.collation.getKeys()).size() < requiredColumns.cardinality() || !ImmutableBitSet.of((ImmutableIntList)idxKeys).contains(requiredColumns)) {
            return false;
        }
        ArrayList keyDefs = new ArrayList(this.idx.indexDefinition().indexKeyDefinitions().values());
        for (InlineIndexKeyType keyType : InlineIndexKeyTypeRegistry.types(keyDefs, (IndexKeyTypeSettings)new IndexKeyTypeSettings())) {
            if (keyType.keySize() >= 0 && keyType.type() != IndexKeyType.JAVA_OBJECT) continue;
            return false;
        }
        return true;
    }
}

