/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingServiceImpl
extends AbstractService
implements MappingService {
    private GridDiscoveryManager discoveryManager;

    public MappingServiceImpl(GridKernalContext ctx) {
        super(ctx);
    }

    public void discoveryManager(GridDiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        this.discoveryManager(ctx.discovery());
    }

    @Override
    public List<UUID> executionNodes(@NotNull AffinityTopologyVersion topVer, boolean single, @Nullable Predicate<ClusterNode> nodeFilter) {
        List<Object> nodes = new ArrayList(this.discoveryManager.discoCache(topVer).serverNodes());
        if (nodeFilter != null) {
            nodes = nodes.stream().filter(nodeFilter).collect(Collectors.toList());
        }
        if (single && nodes.size() > 1) {
            nodes = F.asList((Object)((ClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()))));
        }
        if (F.isEmpty(nodes)) {
            throw new IllegalStateException("failed to map query to execution nodes. Nodes list is empty.");
        }
        return Commons.transform(nodes, ClusterNode::id);
    }
}

