/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.message.ValueMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public final class GenericValueMessage
implements ValueMessage {
    @GridDirectTransient
    private Object val;
    private byte[] serialized;

    public GenericValueMessage() {
    }

    public GenericValueMessage(Object val) {
        this.val = val;
    }

    @Override
    public Object value() {
        return this.val;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        if (this.val != null && this.serialized == null) {
            this.serialized = U.marshal(ctx, (Object)this.val);
        }
    }

    @Override
    public void prepareUnmarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
        if (this.serialized != null && this.val == null) {
            this.val = U.unmarshal(ctx, (byte[])this.serialized, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)ctx.gridConfig()));
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("serialized", this.serialized)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.serialized = reader.readByteArray("serialized");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GenericValueMessage.class);
    }

    @Override
    public MessageType type() {
        return MessageType.GENERIC_VALUE_MESSAGE;
    }

    public byte fieldsCount() {
        return 1;
    }
}

