/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.function.Function;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.util.typedef.F;

public class ProjectNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    private final Function<Row, Row> prj;

    public ProjectNode(ExecutionContext<Row> ctx, RelDataType rowType, Function<Row, Row> prj) {
        super(ctx, rowType);
        this.prj = prj;
    }

    @Override
    protected void rewindInternal() {
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0);
        this.checkState();
        this.source().request(rowsCnt);
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        this.checkState();
        this.downstream().push(this.prj.apply(row));
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        this.checkState();
        this.downstream().end();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

