/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.ObjectSizeCalculator;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.RowTracker;

public abstract class MemoryTrackingNode<Row>
extends AbstractNode<Row> {
    protected static final long HASH_MAP_ROW_OVERHEAD = ObjectSizeCalculator.OBJ_REF_SIZE * 4L / 3L + ObjectSizeCalculator.HASH_MAP_ENTRY_SIZE;
    protected static final long ARRAY_ROW_OVERHEAD;
    protected static final long DFLT_ROW_OVERHEAD;
    protected final RowTracker<Row> nodeMemoryTracker;

    protected MemoryTrackingNode(ExecutionContext<Row> ctx, RelDataType rowType, long rowOverhead) {
        super(ctx, rowType);
        this.nodeMemoryTracker = ctx.createNodeMemoryTracker(rowOverhead);
    }

    protected MemoryTrackingNode(ExecutionContext<Row> ctx, RelDataType rowType) {
        this(ctx, rowType, DFLT_ROW_OVERHEAD);
    }

    @Override
    protected void closeInternal() {
        this.nodeMemoryTracker.reset();
        super.closeInternal();
    }

    static {
        DFLT_ROW_OVERHEAD = ARRAY_ROW_OVERHEAD = ObjectSizeCalculator.OBJ_REF_SIZE;
    }
}

