/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.13.3")
public class MediaType {
    private static final Pattern PATTERN;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_PLAIN_UTF_8;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_JSON_UTF_8;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType IMAGE_JPEG;
    public static final MediaType IMAGE_PNG;
    private final String value;

    public static MediaType parse(String value) {
        return new MediaType(value);
    }

    public static MediaType create(String type, String subtype) {
        Preconditions.notNull((Object)type, (String)"type must not be null");
        Preconditions.notNull((Object)subtype, (String)"subtype must not be null");
        return new MediaType(type + "/" + subtype);
    }

    public static MediaType create(String type, String subtype, Charset charset) {
        Preconditions.notNull((Object)type, (String)"type must not be null");
        Preconditions.notNull((Object)subtype, (String)"subtype must not be null");
        Preconditions.notNull((Object)charset, (String)"charset must not be null");
        return new MediaType(type + "/" + subtype + "; charset=" + charset.name());
    }

    private MediaType(String value) {
        Matcher matcher = PATTERN.matcher((CharSequence)Preconditions.notNull((Object)value, (String)"value must not be null"));
        Preconditions.condition((boolean)matcher.matches(), () -> "Invalid media type: '" + value + "'");
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType that = (MediaType)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    static {
        String whitespace = "[ \t]*";
        String token = "[0-9A-Za-z!#$%&'*+.^_`|~-]+";
        String quotedString = "\"(?:[^\"\\\\]|\\.)*\"";
        String parameter = ";" + whitespace + token + "=(?:" + token + "|" + quotedString + ")";
        PATTERN = Pattern.compile(token + "/" + token + "(?:" + whitespace + parameter + ")*");
        TEXT_PLAIN = MediaType.create("text", "plain");
        TEXT_PLAIN_UTF_8 = MediaType.create("text", "plain", StandardCharsets.UTF_8);
        APPLICATION_JSON = MediaType.create("application", "json");
        APPLICATION_JSON_UTF_8 = MediaType.create("application", "json", StandardCharsets.UTF_8);
        APPLICATION_OCTET_STREAM = MediaType.create("application", "octet-stream");
        IMAGE_JPEG = MediaType.create("image", "jpeg");
        IMAGE_PNG = MediaType.create("image", "png");
    }
}

