/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFactory
implements Reconfigurable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);
    private final ConnectionMode connectionMode;
    private final String clientAuthConfigOverride;
    private final boolean keystoreVerifiableUsingTruststore;
    private String endpointIdentification;
    private SslEngineFactory sslEngineFactory;
    private Map<String, Object> sslEngineFactoryConfig;

    public SslFactory(ConnectionMode connectionMode) {
        this(connectionMode, null, false);
    }

    public SslFactory(ConnectionMode connectionMode, String clientAuthConfigOverride, boolean keystoreVerifiableUsingTruststore) {
        this.connectionMode = connectionMode;
        this.clientAuthConfigOverride = clientAuthConfigOverride;
        this.keystoreVerifiableUsingTruststore = keystoreVerifiableUsingTruststore;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        if (this.sslEngineFactory != null) {
            throw new IllegalStateException("SslFactory was already configured.");
        }
        this.endpointIdentification = (String)configs.get("ssl.endpoint.identification.algorithm");
        Map<String, Object> nextConfigs = configs;
        if (this.clientAuthConfigOverride != null) {
            nextConfigs.put("ssl.client.auth", this.clientAuthConfigOverride);
        }
        SslEngineFactory builder = this.instantiateSslEngineFactory(nextConfigs);
        if (this.keystoreVerifiableUsingTruststore) {
            try {
                SslEngineValidator.validate(builder, builder);
            }
            catch (Exception e) {
                throw new ConfigException("A client SSLEngine created with the provided settings can't connect to a server SSLEngine created with those settings.", (Object)e);
            }
        }
        this.sslEngineFactory = builder;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return this.sslEngineFactory.reconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(Map<String, ?> newConfigs) throws ConfigException {
        try {
            this.createNewSslEngineFactory(newConfigs);
        }
        catch (IllegalStateException e) {
            throw new ConfigException("SSL reconfiguration failed due to " + String.valueOf(e));
        }
    }

    @Override
    public void reconfigure(Map<String, ?> newConfigs) throws KafkaException {
        SslEngineFactory newSslEngineFactory = this.createNewSslEngineFactory(newConfigs);
        if (newSslEngineFactory != this.sslEngineFactory) {
            Utils.closeQuietly(this.sslEngineFactory, "close stale ssl engine factory");
            this.sslEngineFactory = newSslEngineFactory;
            log.info("Created new {} SSL engine builder with keystore {} truststore {}", new Object[]{this.connectionMode, newSslEngineFactory.keystore(), newSslEngineFactory.truststore()});
        }
    }

    private SslEngineFactory instantiateSslEngineFactory(Map<String, Object> configs) {
        Class sslEngineFactoryClass = (Class)configs.get("ssl.engine.factory.class");
        SslEngineFactory sslEngineFactory = sslEngineFactoryClass == null ? new DefaultSslEngineFactory() : (SslEngineFactory)Utils.newInstance(sslEngineFactoryClass);
        sslEngineFactory.configure(configs);
        this.sslEngineFactoryConfig = configs;
        return sslEngineFactory;
    }

    private SslEngineFactory createNewSslEngineFactory(Map<String, ?> newConfigs) {
        if (this.sslEngineFactory == null) {
            throw new IllegalStateException("SslFactory has not been configured.");
        }
        HashMap<String, Object> nextConfigs = new HashMap<String, Object>(this.sslEngineFactoryConfig);
        SslFactory.copyMapEntries(nextConfigs, newConfigs, this.reconfigurableConfigs());
        if (this.clientAuthConfigOverride != null) {
            nextConfigs.put("ssl.client.auth", this.clientAuthConfigOverride);
        }
        if (!this.sslEngineFactory.shouldBeRebuilt(nextConfigs)) {
            return this.sslEngineFactory;
        }
        try {
            SslEngineFactory newSslEngineFactory = this.instantiateSslEngineFactory(nextConfigs);
            if (this.sslEngineFactory.keystore() == null) {
                if (newSslEngineFactory.keystore() != null) {
                    throw new ConfigException("Cannot add SSL keystore to an existing listener for which no keystore was configured.");
                }
            } else {
                if (newSslEngineFactory.keystore() == null) {
                    throw new ConfigException("Cannot remove the SSL keystore from an existing listener for which a keystore was configured.");
                }
                boolean allowDnChanges = ConfigUtils.getBoolean(nextConfigs, "ssl.allow.dn.changes", false);
                boolean allowSanChanges = ConfigUtils.getBoolean(nextConfigs, "ssl.allow.san.changes", false);
                CertificateEntries.ensureCompatible(newSslEngineFactory.keystore(), this.sslEngineFactory.keystore(), allowDnChanges, allowSanChanges);
            }
            if (this.sslEngineFactory.truststore() == null && newSslEngineFactory.truststore() != null) {
                throw new ConfigException("Cannot add SSL truststore to an existing listener for which no truststore was configured.");
            }
            if (this.keystoreVerifiableUsingTruststore && (this.sslEngineFactory.truststore() != null || this.sslEngineFactory.keystore() != null)) {
                SslEngineValidator.validate(this.sslEngineFactory, newSslEngineFactory);
            }
            return newSslEngineFactory;
        }
        catch (Exception e) {
            log.debug("Validation of dynamic config update of SSLFactory failed.", e);
            throw new ConfigException("Validation of dynamic config update of SSLFactory failed: " + String.valueOf(e));
        }
    }

    public SSLEngine createSslEngine(Socket socket) {
        return this.createSslEngine(this.peerHost(socket), socket.getPort());
    }

    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        if (this.sslEngineFactory == null) {
            throw new IllegalStateException("SslFactory has not been configured.");
        }
        if (this.connectionMode == ConnectionMode.SERVER) {
            return this.sslEngineFactory.createServerSslEngine(peerHost, peerPort);
        }
        return this.sslEngineFactory.createClientSslEngine(peerHost, peerPort, this.endpointIdentification);
    }

    private String peerHost(Socket socket) {
        return new InetSocketAddress(socket.getInetAddress(), 0).getHostString();
    }

    public SslEngineFactory sslEngineFactory() {
        return this.sslEngineFactory;
    }

    private static <K, V> void copyMapEntries(Map<K, V> destMap, Map<K, ? extends V> srcMap, Set<K> keySet) {
        for (K k : keySet) {
            SslFactory.copyMapEntry(destMap, srcMap, k);
        }
    }

    private static <K, V> void copyMapEntry(Map<K, V> destMap, Map<K, ? extends V> srcMap, K key) {
        if (srcMap.containsKey(key)) {
            destMap.put(key, srcMap.get(key));
        }
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.sslEngineFactory, "close engine factory");
    }

    private static class SslEngineValidator {
        private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0);
        private final SSLEngine sslEngine;
        private SSLEngineResult handshakeResult;
        private ByteBuffer appBuffer;
        private ByteBuffer netBuffer;

        static void validate(SslEngineFactory oldEngineBuilder, SslEngineFactory newEngineBuilder) throws SSLException {
            SslEngineValidator.validate(SslEngineValidator.createSslEngineForValidation(oldEngineBuilder, ConnectionMode.SERVER), SslEngineValidator.createSslEngineForValidation(newEngineBuilder, ConnectionMode.CLIENT));
            SslEngineValidator.validate(SslEngineValidator.createSslEngineForValidation(newEngineBuilder, ConnectionMode.SERVER), SslEngineValidator.createSslEngineForValidation(oldEngineBuilder, ConnectionMode.CLIENT));
        }

        private static SSLEngine createSslEngineForValidation(SslEngineFactory sslEngineFactory, ConnectionMode connectionMode) {
            if (connectionMode == ConnectionMode.SERVER) {
                return sslEngineFactory.createServerSslEngine("", 0);
            }
            return sslEngineFactory.createClientSslEngine("", 0, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void validate(SSLEngine clientEngine, SSLEngine serverEngine) throws SSLException {
            SslEngineValidator clientValidator = new SslEngineValidator(clientEngine);
            SslEngineValidator serverValidator = new SslEngineValidator(serverEngine);
            try {
                clientValidator.beginHandshake();
                serverValidator.beginHandshake();
                while (!serverValidator.complete() || !clientValidator.complete()) {
                    clientValidator.handshake(serverValidator);
                    serverValidator.handshake(clientValidator);
                }
            }
            finally {
                clientValidator.close();
                serverValidator.close();
            }
        }

        private SslEngineValidator(SSLEngine engine) {
            this.sslEngine = engine;
            this.appBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
            this.netBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        }

        void beginHandshake() throws SSLException {
            this.sslEngine.beginHandshake();
        }

        void handshake(SslEngineValidator peerValidator) throws SSLException {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            block11: while (true) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        this.handshakeResult = this.sslEngine.wrap(EMPTY_BUF, this.netBuffer);
                        switch (this.handshakeResult.getStatus()) {
                            case OK: {
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                if (this.netBuffer.position() != 0) {
                                    return;
                                }
                                this.netBuffer.compact();
                                this.netBuffer = Utils.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                                this.netBuffer.flip();
                                break;
                            }
                            default: {
                                throw new SSLException("Unexpected handshake status: " + String.valueOf((Object)this.handshakeResult.getStatus()));
                            }
                        }
                        return;
                    }
                    case NEED_UNWRAP: {
                        handshakeStatus = this.unwrap(peerValidator, true);
                        if (handshakeStatus != null) continue block11;
                        return;
                    }
                    case NEED_TASK: {
                        this.sslEngine.getDelegatedTask().run();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block11;
                    }
                    case FINISHED: {
                        return;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.handshakeResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                            throw new SSLException("Did not finish handshake, handshake status: " + String.valueOf((Object)this.handshakeResult.getHandshakeStatus()));
                        }
                        if (peerValidator.netBuffer.position() != 0) {
                            this.unwrap(peerValidator, false);
                        }
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unexpected handshake status: " + String.valueOf((Object)handshakeStatus));
        }

        private SSLEngineResult.HandshakeStatus unwrap(SslEngineValidator peerValidator, boolean updateHandshakeResult) throws SSLException {
            peerValidator.netBuffer.flip();
            SSLEngineResult sslEngineResult = this.sslEngine.unwrap(peerValidator.netBuffer, this.appBuffer);
            if (updateHandshakeResult) {
                this.handshakeResult = sslEngineResult;
            }
            peerValidator.netBuffer.compact();
            SSLEngineResult.HandshakeStatus handshakeStatus = sslEngineResult.getHandshakeStatus();
            switch (sslEngineResult.getStatus()) {
                case OK: {
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.appBuffer = Utils.ensureCapacity(this.appBuffer, this.sslEngine.getSession().getApplicationBufferSize());
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    this.netBuffer = Utils.ensureCapacity(this.netBuffer, this.sslEngine.getSession().getPacketBufferSize());
                    return null;
                }
                default: {
                    throw new SSLException("Unexpected handshake status: " + String.valueOf((Object)sslEngineResult.getStatus()));
                }
            }
            return handshakeStatus;
        }

        boolean complete() {
            return this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        void close() {
            this.sslEngine.closeOutbound();
            try {
                this.sslEngine.closeInbound();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class CertificateEntries {
        private final String alias;
        private final Principal subjectPrincipal;
        private final Set<List<?>> subjectAltNames;

        static List<CertificateEntries> create(KeyStore keystore) throws GeneralSecurityException {
            Enumeration<String> aliases = keystore.aliases();
            ArrayList<CertificateEntries> entries = new ArrayList<CertificateEntries>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = keystore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                entries.add(new CertificateEntries(alias, (X509Certificate)cert));
            }
            return entries;
        }

        static void ensureCompatible(KeyStore newKeystore, KeyStore oldKeystore, boolean allowDnChanges, boolean allowSanChanges) throws GeneralSecurityException {
            List<CertificateEntries> newEntries = CertificateEntries.create(newKeystore);
            List<CertificateEntries> oldEntries = CertificateEntries.create(oldKeystore);
            if (!allowDnChanges) {
                CertificateEntries.ensureCompatibleDNs(newEntries, oldEntries);
            }
            if (!allowSanChanges) {
                CertificateEntries.ensureCompatibleSANs(newEntries, oldEntries);
            }
        }

        private static void ensureCompatibleDNs(List<CertificateEntries> newEntries, List<CertificateEntries> oldEntries) {
            if (newEntries.size() != oldEntries.size()) {
                throw new ConfigException(String.format("Keystore entries do not match, existing store contains %d entries, new store contains %d entries", oldEntries.size(), newEntries.size()));
            }
            for (int i = 0; i < newEntries.size(); ++i) {
                CertificateEntries newEntry = newEntries.get(i);
                CertificateEntries oldEntry = oldEntries.get(i);
                Principal newPrincipal = newEntry.subjectPrincipal;
                Principal oldPrincipal = oldEntry.subjectPrincipal;
                if (Objects.equals(newPrincipal, oldPrincipal) || newPrincipal.getName().equalsIgnoreCase(oldPrincipal.getName())) continue;
                throw new ConfigException(String.format("Keystore DistinguishedName does not match:  existing={alias=%s, DN=%s}, new={alias=%s, DN=%s}", oldEntry.alias, oldEntry.subjectPrincipal, newEntry.alias, newEntry.subjectPrincipal));
            }
        }

        private static void ensureCompatibleSANs(List<CertificateEntries> newEntries, List<CertificateEntries> oldEntries) {
            if (newEntries.size() != oldEntries.size()) {
                throw new ConfigException(String.format("Keystore entries do not match, existing store contains %d entries, new store contains %d entries", oldEntries.size(), newEntries.size()));
            }
            for (int i = 0; i < newEntries.size(); ++i) {
                CertificateEntries newEntry = newEntries.get(i);
                CertificateEntries oldEntry = oldEntries.get(i);
                if (newEntry.subjectAltNames.containsAll(oldEntry.subjectAltNames)) continue;
                throw new ConfigException(String.format("Keystore SubjectAltNames do not match:  existing={alias=%s, SAN=%s}, new={alias=%s, SAN=%s}", oldEntry.alias, oldEntry.subjectAltNames, newEntry.alias, newEntry.subjectAltNames));
            }
        }

        CertificateEntries(String alias, X509Certificate cert) throws GeneralSecurityException {
            this.alias = alias;
            this.subjectPrincipal = cert.getSubjectX500Principal();
            Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
            this.subjectAltNames = altNames != null ? new HashSet(altNames) : Collections.emptySet();
        }

        public int hashCode() {
            return Objects.hash(this.subjectPrincipal, this.subjectAltNames);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CertificateEntries)) {
                return false;
            }
            CertificateEntries other = (CertificateEntries)obj;
            return Objects.equals(this.subjectPrincipal, other.subjectPrincipal) && Objects.equals(this.subjectAltNames, other.subjectAltNames);
        }

        public String toString() {
            return "subjectPrincipal=" + String.valueOf(this.subjectPrincipal) + ", subjectAltNames=" + String.valueOf(this.subjectAltNames);
        }
    }
}

