/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.kerby.kerberos.kerb.type.base;

import java.net.InetAddress;

import org.apache.kerby.kerberos.kerb.type.KrbSequenceOfType;

/**
 * The HostAddress as defined in RFC 4120 :
 * <pre>
 * -- NOTE: HostAddresses is always used as an OPTIONAL field and
 * -- should not be empty.
 * HostAddresses   -- NOTE: subtly different from rfc1510,
 *                 -- but has a value mapping and encodes the same
 *         ::= SEQUENCE OF HostAddress
 * </pre>
 * 
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class HostAddresses extends KrbSequenceOfType<HostAddress> {
    /**
     * Tells if the list of HostAddresses contain a given HostAddress
     * @param address The {@link InetAddress} we are looking for
     * @return <tt>true</tt> if it's present
     */
    public boolean contains(InetAddress address) {
        for (HostAddress hostAddress : getElements()) {
            if (hostAddress.equalsWith(address)) {
                return true;
            }
        }
        
        return false;
    }
}
