/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.Properties;
import org.apache.directory.fortress.core.ConfigMgr;
import org.apache.directory.fortress.core.ConfigMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfigMgrImpl.class.getName());

    ConfigMgrImpl() {
    }

    FortResponse addConfig(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ConfigMgr configMgr = ConfigMgrFactory.createInstance();
            Configuration inCfg = (Configuration)request.getEntity();
            Configuration outCfg = configMgr.add(inCfg);
            if (outCfg != null) {
                response.setEntity((FortEntity)outCfg);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateConfig(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ConfigMgr configMgr = ConfigMgrFactory.createInstance();
            Configuration inCfg = (Configuration)request.getEntity();
            Configuration outCfg = configMgr.update(inCfg);
            if (outCfg != null) {
                response.setEntity((FortEntity)outCfg);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteConfig(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ConfigMgr configMgr = ConfigMgrFactory.createInstance();
            if (request.getEntity() == null) {
                configMgr.delete(request.getValue());
            } else {
                Properties inProperties = RestUtils.getProperties((Props)((Props)request.getEntity()));
                configMgr.delete(request.getValue(), inProperties);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readConfig(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            ConfigMgr configMgr = ConfigMgrFactory.createInstance();
            Configuration outCfg = configMgr.read(request.getValue());
            if (outCfg != null) {
                response.setEntity((FortEntity)outCfg);
            }
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

