/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.throttling;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.apache.deltaspike.core.api.throttling.Throttled;
import org.apache.deltaspike.core.api.throttling.Throttling;
import org.apache.deltaspike.core.impl.throttling.Invoker;
import org.apache.deltaspike.core.impl.util.AnnotatedMethods;

@ApplicationScoped
@Typed(value={InvokerStorage.class})
public class InvokerStorage
implements Throttling.SemaphoreFactory {
    private final ConcurrentMap<String, Semaphore> semaphores = new ConcurrentHashMap<String, Semaphore>();
    private final ConcurrentMap<Method, Invoker> providers = new ConcurrentHashMap<Method, Invoker>();
    @Inject
    private BeanManager beanManager;

    Invoker getOrCreateInvoker(InvocationContext ic) {
        Method method = ic.getMethod();
        Invoker i = (Invoker)this.providers.get(method);
        if (i == null) {
            Throttling sharedConfig;
            Class<?> declaringClass = method.getDeclaringClass();
            AnnotatedType annotatedType = this.beanManager.createAnnotatedType(declaringClass);
            AnnotatedMethod<?> annotatedMethod = AnnotatedMethods.findMethod(annotatedType, method);
            Throttled config = (Throttled)annotatedMethod.getAnnotation(Throttled.class);
            if (config == null) {
                config = (Throttled)annotatedType.getAnnotation(Throttled.class);
            }
            if ((sharedConfig = (Throttling)annotatedMethod.getAnnotation(Throttling.class)) == null) {
                sharedConfig = (Throttling)annotatedType.getAnnotation(Throttling.class);
            }
            InvokerStorage factory = sharedConfig != null && sharedConfig.factory() != Throttling.SemaphoreFactory.class ? (Throttling.SemaphoreFactory)Throttling.SemaphoreFactory.class.cast(this.beanManager.getReference(this.beanManager.resolve(this.beanManager.getBeans((Type)sharedConfig.factory(), new Annotation[0])), Throttling.SemaphoreFactory.class, null)) : this;
            Semaphore semaphore = factory.newSemaphore(annotatedMethod, sharedConfig != null && !sharedConfig.name().isEmpty() ? sharedConfig.name() : declaringClass.getName(), sharedConfig != null && sharedConfig.fair(), sharedConfig != null ? sharedConfig.permits() : 1);
            long timeout = config.timeoutUnit().toMillis(config.timeout());
            int weigth = config.weight();
            i = new Invoker(semaphore, weigth, timeout);
            Invoker existing = this.providers.putIfAbsent(ic.getMethod(), i);
            if (existing != null) {
                i = existing;
            }
        }
        return i;
    }

    public Semaphore newSemaphore(AnnotatedMethod<?> method, String name, boolean fair, int permits) {
        Semaphore existing;
        Semaphore semaphore = (Semaphore)this.semaphores.get(name);
        if (semaphore == null && (existing = this.semaphores.putIfAbsent(name, semaphore = new Semaphore(permits, fair))) != null) {
            semaphore = existing;
        }
        return semaphore;
    }
}

