/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.jmx;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import org.apache.deltaspike.core.api.jmx.JmxBroadcaster;
import org.apache.deltaspike.core.api.jmx.MBean;
import org.apache.deltaspike.core.impl.jmx.MBeanExtension;

@ApplicationScoped
public class BroadcasterProducer {
    @Inject
    private MBeanExtension extension;

    @Produces
    @Dependent
    public JmxBroadcaster jmxBroadcaster(InjectionPoint ip) {
        Class<?> declaringClass = ip.getMember().getDeclaringClass();
        JmxBroadcaster broadcaster = this.extension.getBroadcasterFor(declaringClass);
        if (broadcaster == null) {
            throw new IllegalStateException("Invalid injection of " + JmxBroadcaster.class.getName() + " in " + declaringClass.getName() + " detected. It is required to annotate the class with @" + MBean.class.getName());
        }
        return broadcaster;
    }
}

