/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.annotations.Test;

public class DoublesUtilTest {
    @Test
    public void checkPrintSegmentData() {
        int k = 16;
        int n = 1000;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(16, 1000);
        byte[] byteArr = qs.toByteArray(false);
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        DoublesUtilTest.println(DoublesUtilTest.segToString(true, true, seg));
        byteArr = qs.toByteArray(true);
        seg = MemorySegment.ofArray(byteArr);
        DoublesUtilTest.println(DoublesUtilTest.segToString(true, true, seg));
    }

    @Test
    public void checkPrintSegmentData2() {
        int k = 128;
        boolean n = false;
        UpdatableQuantilesDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 0);
        byte[] byteArr = qs.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        DoublesUtilTest.println(DoublesUtilTest.segToString(true, true, seg));
    }

    static String segToString(boolean withLevels, boolean withLevelsAndItems, MemorySegment seg) {
        QuantilesDoublesSketch ds = QuantilesDoublesSketch.heapify((MemorySegment)seg);
        return ds.toString(withLevels, withLevelsAndItems);
    }

    @Test
    public void checkCopyToHeap() {
        int k = 128;
        int n = 400;
        HeapUpdateDoublesSketch huds = (HeapUpdateDoublesSketch)HeapUpdateDoublesSketchTest.buildAndLoadQS(128, 400);
        HeapUpdateDoublesSketch target1 = DoublesUtil.copyToHeap((QuantilesDoublesSketch)huds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)huds, (QuantilesDoublesSketch)target1);
        MemorySegment seg1 = MemorySegment.ofArray(huds.toByteArray());
        DirectUpdateDoublesSketch duds = (DirectUpdateDoublesSketch)UpdatableQuantilesDoublesSketch.wrap((MemorySegment)seg1, null);
        HeapUpdateDoublesSketch target2 = DoublesUtil.copyToHeap((QuantilesDoublesSketch)duds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)huds, (QuantilesDoublesSketch)duds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)duds, (QuantilesDoublesSketch)target2);
        CompactQuantilesDoublesSketch hcds = huds.compact();
        HeapUpdateDoublesSketch target3 = DoublesUtil.copyToHeap((QuantilesDoublesSketch)hcds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)huds, (QuantilesDoublesSketch)hcds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)hcds, (QuantilesDoublesSketch)target3);
        MemorySegment seg2 = MemorySegment.ofArray(hcds.toByteArray());
        DirectCompactDoublesSketch dcds = (DirectCompactDoublesSketch)QuantilesDoublesSketch.wrap((MemorySegment)seg2);
        HeapUpdateDoublesSketch target4 = DoublesUtil.copyToHeap((QuantilesDoublesSketch)dcds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)huds, (QuantilesDoublesSketch)dcds);
        DoublesSketchTest.testSketchEquality((QuantilesDoublesSketch)dcds, (QuantilesDoublesSketch)target4);
    }

    @Test
    public void printlnTest() {
        DoublesUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DoublesUtilTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

