/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class Whitespace {
    private static final ARegularExpression anyWhitespace = ARegularExpression.compile(StringTool.fromLatin1("[ \\n\\r\\t]+"), "");
    private static final Pattern J_oneWhitespace = Pattern.compile("[ \\n\\r\\t]");
    private static final Pattern J_anyWhitespace = Pattern.compile("[ \\n\\r\\t]+");
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int TRIM = 3;
    public static final int NONE = 0;
    public static final int IGNORABLE = 1;
    public static final int ALL = 2;
    public static final int UNSPECIFIED = 3;
    public static final int XSLT = 4;
    private static final boolean[] C0WHITE = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};

    private Whitespace() {
    }

    public static UnicodeString applyWhitespaceNormalization(int action, UnicodeString value) {
        switch (action) {
            case 0: {
                return value;
            }
            case 1: {
                UnicodeBuilder sb = new UnicodeBuilder(value.length32());
                IntIterator iter = value.codePoints();
                block9: while (iter.hasNext()) {
                    int c = iter.next();
                    switch (c) {
                        case 9: 
                        case 10: 
                        case 13: {
                            sb.append(' ');
                            continue block9;
                        }
                    }
                    sb.append(c);
                }
                return sb.toUnicodeString();
            }
            case 2: {
                return Whitespace.collapseWhitespace(value);
            }
            case 3: {
                return Whitespace.trim(value);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static String removeAllWhitespace(String value) {
        return J_oneWhitespace.matcher(value).replaceAll("");
    }

    public static UnicodeString removeLeadingWhitespace(UnicodeString value) {
        long start = Whitespace.trimmedStart(value);
        if (start == 0L) {
            return value;
        }
        if (start < 0L) {
            return EmptyUnicodeString.getInstance();
        }
        return value.substring(start);
    }

    public static boolean containsWhitespace(IntIterator codePoints) {
        while (codePoints.hasNext()) {
            int c = codePoints.next();
            if (c > 32 || !C0WHITE[c]) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllWhite(UnicodeString content) {
        if (content instanceof WhitespaceString) {
            return true;
        }
        return content.indexWhere(ch -> !Whitespace.isWhite(ch), 0L) < 0L;
    }

    private static void tokenize(IntIterator input, TokenHandler handler) {
        int position = 0;
        int tokenStart = 0;
        TokenCategory currentCategory = TokenCategory.INITIAL_WHITESPACE;
        while (input.hasNext()) {
            int ch = input.next();
            if (Whitespace.isWhite(ch)) {
                if (currentCategory == TokenCategory.CONTENT) {
                    handler.handleToken(tokenStart, position, currentCategory);
                    tokenStart = position;
                    currentCategory = TokenCategory.SEPARATOR_WHITESPACE;
                }
            } else if (currentCategory != TokenCategory.CONTENT) {
                if (position > 0) {
                    handler.handleToken(tokenStart, position, currentCategory);
                }
                tokenStart = position;
                currentCategory = TokenCategory.CONTENT;
            }
            ++position;
        }
        if (position > tokenStart) {
            if (currentCategory == TokenCategory.SEPARATOR_WHITESPACE) {
                handler.handleToken(tokenStart, position, TokenCategory.FINAL_WHITESPACE);
            } else {
                handler.handleToken(tokenStart, position, currentCategory);
            }
        }
    }

    public static boolean isWhite(int c) {
        return c <= 32 && C0WHITE[c];
    }

    public static UnicodeString normalizeWhitespace(UnicodeString input) {
        UnicodeBuilder sb = new UnicodeBuilder(input.length32());
        IntIterator iter = input.codePoints();
        block3: while (iter.hasNext()) {
            int c = iter.next();
            switch (c) {
                case 9: 
                case 10: 
                case 13: {
                    sb.append(' ');
                    continue block3;
                }
            }
            sb.append(c);
        }
        return sb.toUnicodeString();
    }

    public static UnicodeString collapseWhitespace(UnicodeString in) {
        if (!Whitespace.containsWhitespace(in.codePoints())) {
            return in;
        }
        long len = Whitespace.trimmedEnd(in);
        UnicodeBuilder sb = new UnicodeBuilder(in.length32());
        boolean inWhitespace = true;
        block3: for (long i = 0L; i < len; ++i) {
            int c = in.codePointAt(i);
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (inWhitespace) continue block3;
                    sb.append(32);
                    inWhitespace = true;
                    continue block3;
                }
                default: {
                    sb.append(c);
                    inWhitespace = false;
                }
            }
        }
        return sb.toUnicodeString();
    }

    public static String collapseWhitespace(String in) {
        if (!Whitespace.containsWhitespace(StringTool.codePoints(in))) {
            return in;
        }
        return Whitespace.trim(J_anyWhitespace.matcher(in).replaceAll(" "));
    }

    public static long trimmedStart(UnicodeString in) {
        long len = in.length();
        int i = 0;
        while ((long)i < len) {
            if (!Whitespace.isWhite(in.codePointAt(i))) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public static long trimmedEnd(UnicodeString in) {
        long len = in.length();
        for (long i = len - 1L; i >= 0L; --i) {
            if (Whitespace.isWhite(in.codePointAt(i))) continue;
            return i + 1L;
        }
        return 0L;
    }

    public static UnicodeString trim(UnicodeString in) {
        long start = Whitespace.trimmedStart(in);
        if (start == -1L) {
            return EmptyUnicodeString.getInstance();
        }
        long end = Whitespace.trimmedEnd(in);
        if (start == 0L && end == in.length()) {
            return in;
        }
        return in.substring(start, end);
    }

    public static String trim(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int firstNonWhite = -1;
        int lastNonWhite = -1;
        int len = in.length();
        for (i = 0; i < len; ++i) {
            if (Whitespace.isWhite(in.charAt(i))) continue;
            firstNonWhite = i;
            break;
        }
        if (firstNonWhite == -1) {
            return "";
        }
        for (i = len - 1; i >= firstNonWhite; --i) {
            if (Whitespace.isWhite(in.charAt(i))) continue;
            lastNonWhite = i;
            break;
        }
        if (firstNonWhite == 0 && lastNonWhite == in.length()) {
            return in;
        }
        return in.substring(firstNonWhite, lastNonWhite + 1);
    }

    public static UnicodeString collapse(UnicodeString in) {
        UnicodeBuilder builder = new UnicodeBuilder(in.length32());
        Whitespace.tokenize(in.codePoints(), (s, e, cat) -> {
            TokenCategory category = cat;
            switch (category.ordinal()) {
                case 3: {
                    builder.accept(in.substring(s, e));
                    break;
                }
                case 1: {
                    builder.append(' ');
                    break;
                }
            }
        });
        return builder.toUnicodeString();
    }

    public static String collapse(CharSequence in) {
        StringBuilder builder = new StringBuilder(in.length());
        Whitespace.tokenize(StringTool.codePoints(in), (s, e, cat) -> {
            TokenCategory category = cat;
            switch (category.ordinal()) {
                case 3: {
                    builder.append(in.subSequence(s, e));
                    break;
                }
                case 1: {
                    builder.append(' ');
                    break;
                }
            }
        });
        return builder.toString();
    }

    public static UnicodeString normalize(UnicodeString in) {
        UnicodeBuilder builder = new UnicodeBuilder(in.length32());
        Whitespace.tokenize(in.codePoints(), (s, e, cat) -> {
            TokenCategory category = cat;
            switch (category.ordinal()) {
                case 3: {
                    builder.accept(in.substring(s, e));
                    break;
                }
                case 1: {
                    for (int i = s; i < e; ++i) {
                        builder.append(' ');
                    }
                    break;
                }
            }
        });
        return builder.toUnicodeString();
    }

    public static String normalize(CharSequence in) {
        StringBuilder builder = new StringBuilder(in.length());
        Whitespace.tokenize(StringTool.codePoints(in), (s, e, cat) -> {
            TokenCategory category = cat;
            switch (category.ordinal()) {
                case 3: {
                    builder.append(in.subSequence(s, e));
                    break;
                }
                case 1: {
                    for (int i = s; i < e; ++i) {
                        builder.append(' ');
                    }
                    break;
                }
            }
        });
        return builder.toString();
    }

    private static enum TokenCategory {
        INITIAL_WHITESPACE,
        SEPARATOR_WHITESPACE,
        FINAL_WHITESPACE,
        CONTENT;

    }

    @FunctionalInterface
    private static interface TokenHandler {
        public void handleToken(int var1, int var2, TokenCategory var3);
    }

    public static class Tokenizer
    implements AtomicIterator {
        private final UnicodeString input;
        private long position;

        public Tokenizer(String input) {
            this.input = StringView.tidy(input);
            this.position = 0L;
        }

        public Tokenizer(UnicodeString input) {
            this.input = input.tidy();
            this.position = 0L;
        }

        @Override
        public StringValue next() {
            long end;
            long start;
            long eol = this.input.length();
            for (start = this.position; start < eol && Whitespace.isWhite(this.input.codePointAt(start)); ++start) {
            }
            if (start >= eol) {
                return null;
            }
            for (end = start; end < eol && !Whitespace.isWhite(this.input.codePointAt(end)); ++end) {
            }
            this.position = end;
            return new StringValue(this.input.substring(start, end));
        }
    }
}

