/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class PackageVersionRanges {
    private final ArrayList<PackageVersionRange> ranges = new ArrayList();

    public PackageVersionRanges(String s) throws XPathException {
        String trimmed = Whitespace.normalize(s);
        if (trimmed.equals("*")) {
            this.ranges.add(new PackageVersionRange());
        } else {
            for (String p : trimmed.split("\\s?,\\s?")) {
                this.ranges.add(new PackageVersionRange(p));
            }
        }
    }

    public boolean contains(PackageVersion version) {
        for (PackageVersionRange r : this.ranges) {
            if (!r.contains(version)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.ranges.size() == 1) {
            return this.ranges.get(0).toString();
        }
        StringBuilder buffer = new StringBuilder(256);
        for (PackageVersionRange r : this.ranges) {
            buffer.append(r.toString()).append(",");
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    private static class PackageVersionRange {
        private final String display;
        private PackageVersion low;
        private PackageVersion high;
        private boolean all = false;
        private boolean prefix = false;

        public PackageVersionRange(String s) throws XPathException {
            this.display = s;
            if (s.endsWith("+")) {
                this.low = new PackageVersion(s.replace("+", ""));
                this.high = PackageVersion.MAX_VALUE;
            } else if (s.matches("^to\\s.*")) {
                this.low = PackageVersion.ZERO;
                String end = s.substring(3);
                if (end.endsWith(".*")) {
                    this.high = new PackageVersion(end.substring(0, end.length() - 2));
                    this.prefix = true;
                } else {
                    this.high = new PackageVersion(end);
                }
            } else if (s.matches(".*\\s?to\\s+.*")) {
                String[] range = s.split("\\s*to\\s+");
                if (range.length > 2) {
                    throw new XPathException("Invalid version range:" + s, "XTSE0020");
                }
                this.low = new PackageVersion(range[0]);
                String end = range[1];
                if (end.endsWith(".*")) {
                    this.high = new PackageVersion(end.substring(0, end.length() - 2));
                    this.prefix = true;
                } else {
                    this.high = new PackageVersion(end);
                }
            } else if (s.endsWith(".*")) {
                this.prefix = true;
                this.low = new PackageVersion(s.substring(0, s.length() - 2));
            } else {
                this.high = this.low = new PackageVersion(s);
            }
        }

        public PackageVersionRange() {
            this.display = "*";
            this.all = true;
        }

        boolean contains(PackageVersion v) {
            if (this.all) {
                return true;
            }
            if (this.prefix) {
                if (this.high != null) {
                    return this.low.compareTo(v) <= 0 && (v.compareTo(this.high) <= 0 || this.high.isPrefix(v));
                }
                return this.low.isPrefix(v);
            }
            return this.low.compareTo(v) <= 0 && v.compareTo(this.high) <= 0;
        }

        public String toString() {
            return this.display;
        }
    }
}

