/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateProxy;

public class JsonHandler {
    public boolean escape;
    protected IntPredicateProxy charChecker;
    private XPathContext context;
    private FunctionItem fallbackFunction = null;
    private static final String REPLACEMENT = "\ufffd";

    public void setContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getContext() {
        return this.context;
    }

    public Sequence getResult() throws XPathException {
        return null;
    }

    public boolean setKey(String unEscaped, String reEscaped) {
        return false;
    }

    public void startArray() throws XPathException {
    }

    public void endArray() throws XPathException {
    }

    public void startMap() throws XPathException {
    }

    public void endMap() throws XPathException {
    }

    public void writeNumeric(String asString, AtomicValue parsedValue) throws XPathException {
    }

    public void writeString(String val) throws XPathException {
    }

    public String reEscape(String val) throws XPathException {
        String escaped;
        if (this.escape) {
            escaped = JsonReceiver.escape(val, true, true, value -> value >= 0 && value <= 31 || value >= 127 && value <= 159 || !this.charChecker.test(value) || value == 92);
        } else {
            StringBuilder buffer = new StringBuilder(val);
            this.handleInvalidCharacters(buffer);
            escaped = buffer.toString();
        }
        return escaped;
    }

    public void writeBoolean(boolean value) throws XPathException {
    }

    public void writeNull() throws XPathException {
    }

    protected void handleInvalidCharacters(StringBuilder buffer) throws XPathException {
        IntPredicateProxy charChecker = this.context.getConfiguration().getValidCharacterChecker();
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            if (UTF16CharacterSet.isHighSurrogate(ch)) {
                if (i + 1 < buffer.length() && UTF16CharacterSet.isLowSurrogate(buffer.charAt(i + 1))) continue;
                this.substitute(buffer, i, 1, this.context);
                continue;
            }
            if (UTF16CharacterSet.isLowSurrogate(ch)) {
                if (i == 0 || !UTF16CharacterSet.isHighSurrogate(buffer.charAt(i - 1))) {
                    this.substitute(buffer, i, 1, this.context);
                    continue;
                }
                int pair = UTF16CharacterSet.combinePair(buffer.charAt(i - 1), ch);
                if (charChecker.test(pair)) continue;
                this.substitute(buffer, i - 1, 2, this.context);
                continue;
            }
            if (charChecker.test(ch)) continue;
            this.substitute(buffer, i, 1, this.context);
        }
    }

    protected void markAsEscaped(String escaped, boolean isKey) throws XPathException {
    }

    private void substitute(StringBuilder buffer, int offset, int count, XPathContext context) throws XPathException {
        StringBuilder escaped = new StringBuilder(count * 6);
        for (int j = 0; j < count; ++j) {
            escaped.append("\\u");
            StringBuilder hex = new StringBuilder(Integer.toHexString(buffer.charAt(offset + j)));
            while (hex.length() < 4) {
                hex.insert(0, "0");
            }
            escaped.append(hex.toString().toUpperCase());
        }
        String replacement = this.replace(escaped.toString(), context);
        if (replacement.length() == count) {
            for (int j = 0; j < count; ++j) {
                buffer.setCharAt(offset + j, replacement.charAt(j));
            }
        } else {
            int j;
            for (j = 0; j < count; ++j) {
                buffer.deleteCharAt(offset + j);
            }
            for (j = 0; j < replacement.length(); ++j) {
                buffer.insert(offset + j, replacement.charAt(j));
            }
        }
    }

    private String replace(String s, XPathContext context) throws XPathException {
        if (this.fallbackFunction != null) {
            Sequence[] args = new Sequence[]{new StringValue(s)};
            Item result = SystemFunction.dynamicCall(this.fallbackFunction, context, args).head();
            Item first = result.head();
            return first == null ? "" : first.getStringValue();
        }
        return REPLACEMENT;
    }

    public void setFallbackFunction(Map<String, GroundedValue> options, XPathContext context) throws XPathException {
        GroundedValue val = options.get("fallback");
        if (val != null) {
            Item fn = val.head();
            if (fn instanceof FunctionItem) {
                this.fallbackFunction = (FunctionItem)fn;
                if (this.fallbackFunction.getArity() != 1) {
                    throw new XPathException("Fallback function must have arity=1", "FOJS0005");
                }
                SpecificFunctionType required = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.ANY_SEQUENCE);
                if (!required.matches(this.fallbackFunction, context.getConfiguration().getTypeHierarchy())) {
                    throw new XPathException("Fallback function does not match the required type", "FOJS0005");
                }
            } else {
                throw new XPathException("Value of option 'fallback' is not a function", "FOJS0005");
            }
        }
    }
}

