/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.transform.Source;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;

public class ProtocolRestrictor {
    private final Predicate<URI> predicate;
    private final String originalRule;

    public ProtocolRestrictor(String value) {
        Objects.requireNonNull(value);
        this.originalRule = value;
        value = value.trim();
        if (value.equals("all")) {
            this.predicate = uri -> true;
        } else {
            String[] tokens;
            ArrayList<Predicate<URI>> permitted = new ArrayList<Predicate<URI>>();
            for (String token : tokens = value.split(",\\s*")) {
                if (token.startsWith("jar:") && token.length() > 4) {
                    String subScheme = token.substring(4).toLowerCase();
                    permitted.add(uri -> ProtocolRestrictor.scheme(uri).equals("jar") && ProtocolRestrictor.schemeSpecificPart(uri).toLowerCase().startsWith(subScheme));
                    continue;
                }
                permitted.add(uri -> ProtocolRestrictor.scheme(uri).equals(token));
            }
            this.predicate = uri -> {
                for (Predicate pred : permitted) {
                    if (!pred.test(uri)) continue;
                    return true;
                }
                return false;
            };
        }
    }

    public boolean test(URI uri) {
        return this.predicate.test(uri);
    }

    public String toString() {
        return this.originalRule;
    }

    public ResourceResolver asResourceResolver(ResourceResolver existing) {
        return new RestrictedResourceResolver(this, existing);
    }

    private static String scheme(URI uri) {
        return uri.getScheme();
    }

    private static String schemeSpecificPart(URI uri) {
        return uri.getSchemeSpecificPart();
    }

    public static class RestrictedResourceResolver
    implements ResourceResolver {
        private final ProtocolRestrictor protocolRestrictor;
        private final ResourceResolver nextResolver;

        public RestrictedResourceResolver(ProtocolRestrictor pr, ResourceResolver rr) {
            this.protocolRestrictor = pr;
            this.nextResolver = rr;
        }

        public void setAllowedProtocols(String protocols) {
            if (this.nextResolver instanceof CatalogResourceResolver) {
                CatalogResourceResolver catres = (CatalogResourceResolver)this.nextResolver;
                catres.setAllowedProtocols(protocols);
            }
        }

        @Override
        public Source resolve(ResourceRequest request) throws XPathException {
            if (this.protocolRestrictor.test(URI.create(request.uri))) {
                return this.nextResolver.resolve(request);
            }
            throw new XPathException("Access to URI " + request.uri + " has been prohibited");
        }
    }
}

