/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class FunctionLibraryList
implements FunctionLibrary,
XQueryFunctionBinder {
    public List<FunctionLibrary> libraryList = new ArrayList<FunctionLibrary>(8);

    public int addFunctionLibrary(FunctionLibrary lib) {
        this.libraryList.add(lib);
        return this.libraryList.size() - 1;
    }

    public FunctionLibrary get(int n) {
        return this.libraryList.get(n);
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        for (FunctionLibrary lib : this.libraryList) {
            FunctionItem fi = lib.getFunctionItem(functionName, staticContext);
            if (fi == null) continue;
            return fi;
        }
        return null;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        for (FunctionLibrary lib : this.libraryList) {
            if (!lib.isAvailable(functionName, languageLevel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        boolean debug = env.getConfiguration().getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS) && !NamespaceUri.isReserved(functionName.getComponentName().getNamespaceUri());
        Logger err = env.getConfiguration().getLogger();
        if (debug) {
            err.info("Looking for function " + functionName.getComponentName().getEQName() + "#" + functionName.getArity());
        }
        for (FunctionLibrary lib : this.libraryList) {
            Expression func;
            if (debug) {
                err.info("Trying " + lib.getClass().getName());
            }
            if ((func = lib.bind(functionName, staticArgs, keywords, env, reasons)) == null) continue;
            return func;
        }
        if (debug) {
            err.info("Function " + functionName.getComponentName().getEQName() + " not found!");
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, int staticArgs) {
        for (FunctionLibrary lib : this.libraryList) {
            XQueryFunction func;
            if (!(lib instanceof XQueryFunctionBinder) || (func = ((XQueryFunctionBinder)lib).getDeclaration(functionName, staticArgs)) == null) continue;
            return func;
        }
        return null;
    }

    @Override
    public boolean bindUnboundFunctionCall(UserFunctionCall call, List<String> reasons) {
        for (FunctionLibrary lib : this.libraryList) {
            boolean found;
            if (!(lib instanceof XQueryFunctionBinder) || !(found = ((XQueryFunctionBinder)lib).bindUnboundFunctionCall(call, reasons))) continue;
            return true;
        }
        return false;
    }

    public List<FunctionLibrary> getLibraryList() {
        return this.libraryList;
    }

    @Override
    public FunctionLibrary copy() {
        FunctionLibraryList fll = new FunctionLibraryList();
        fll.libraryList = FunctionLibraryList.emptyFunctionLibraryList(this.libraryList.size());
        for (int i = 0; i < this.libraryList.size(); ++i) {
            fll.libraryList.add(this.libraryList.get(i).copy());
        }
        return fll;
    }

    private static ArrayList<FunctionLibrary> emptyFunctionLibraryList(int allocated) {
        return new ArrayList<FunctionLibrary>(allocated);
    }
}

