/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.DiagnosticClause;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class DiagnosticClausePull
extends TuplePull {
    TuplePull base;
    DiagnosticClause diagClause;
    int tupleSeq = 1;

    public DiagnosticClausePull(TuplePull base, DiagnosticClause diagClause) {
        this.base = base;
        this.diagClause = diagClause;
    }

    @Override
    public boolean nextTuple(XPathContext context) throws XPathException {
        Item item;
        if (!this.base.nextTuple(context)) {
            return false;
        }
        SequenceIterator val = this.diagClause.getEvaluator().iterate(context);
        Logger out = context.getController().getTraceFunctionDestination();
        int pos = 1;
        while ((item = val.next()) != null) {
            String label = "FLWOR<- " + this.tupleSeq + "/" + pos++;
            Trace.traceItem(item, label, out);
        }
        ++this.tupleSeq;
        return true;
    }

    @Override
    public void close() {
        this.base.close();
    }
}

