/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.LengthEv;
import org.apache.daffodil.runtime1.processors.TextTruncationType;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.StringSpecifiedLengthUnparserTruncateBase;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class StringMaybeTruncateCharactersUnparser
extends StringSpecifiedLengthUnparserTruncateBase {
    private final LengthEv lengthInCharactersEv;

    public StringMaybeTruncateCharactersUnparser(LengthEv lengthInCharactersEv, TextTruncationType.Type stringTruncationType, ElementRuntimeData erd) {
        this.lengthInCharactersEv = lengthInCharactersEv;
        super(stringTruncationType, erd);
    }

    private ElementRuntimeData erd$accessor() {
        return super.erd();
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LengthEv[]{this.lengthInCharactersEv}));
    }

    @Override
    public void unparse(UState state) {
        String string;
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        String valueString = this.contentString(state);
        Long targetLengthInCharacters = (Long)((Evaluatable)((Object)this.lengthInCharactersEv)).evaluate(state);
        if (Predef$.MODULE$.Long2long(targetLengthInCharacters) >= (long)valueString.length()) {
            string = valueString;
        } else {
            long nChars = valueString.length();
            long nCharsToTrim = nChars - Predef$.MODULE$.Long2long(targetLengthInCharacters);
            if (nCharsToTrim > nChars) {
                throw Assert$.MODULE$.abort("Invariant broken: nCharsToTrim.<=(nChars)");
            }
            String truncatedValue = this.truncateByJustification(state, valueString, nChars - (long)((int)nCharsToTrim));
            if (truncatedValue.length() > valueString.length()) {
                throw Assert$.MODULE$.abort("Invariant broken: truncatedValue.length().<=(valueString.length())");
            }
            string = truncatedValue;
        }
        String valueToWrite = string;
        long nCharsWritten = dos.putString(valueToWrite, state);
        if (nCharsWritten != (long)valueToWrite.length()) {
            throw Assert$.MODULE$.abort("Invariant broken: nCharsWritten.==(valueToWrite.length())");
        }
    }
}

