/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.iapi;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.xml.sax.InputSource;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class URISchemaSource
implements DaffodilSchemaSource {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(URISchemaSource.class.getDeclaredField("$1$$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(URISchemaSource.class.getDeclaredField("url$lzy1"));
    private final File diagnosticFilepath;
    private final URI uri;
    private volatile Object url$lzy1;
    private volatile Object $1$$lzy1;

    public static URISchemaSource apply(File file, URI uRI) {
        return URISchemaSource$.MODULE$.apply(file, uRI);
    }

    public URISchemaSource(File diagnosticFilepath, URI uri) {
        this.diagnosticFilepath = diagnosticFilepath;
        this.uri = uri;
    }

    public URI uri() {
        return this.uri;
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof URISchemaSource) {
            URISchemaSource oth = (URISchemaSource)object;
            URI uRI = this.uri();
            URI uRI2 = oth.uri();
            return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.uri().hashCode();
    }

    private URL url() {
        Object object = this.url$lzy1;
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (URL)this.url$lzyINIT1();
    }

    private Object url$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.url$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    URL uRL = null;
                    try {
                        uRL = this.uri().toURL();
                        object2 = uRL == null ? LazyVals.NullValue$.MODULE$ : uRL;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.url$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uRL;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final boolean isXSD() {
        return this.isXSD_();
    }

    private Tuple4<Object, Object, File, Object> $1$() {
        Object object = this.$1$$lzy1;
        if (object instanceof Tuple4) {
            return (Tuple4)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple4)this.$1$$lzyINIT1();
    }

    private Object $1$$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.$1$$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple4 tuple4 = null;
                    try {
                        Tuple4 tuple42;
                        Tuple4 tuple43;
                        String ext;
                        String uriString = this.uriForLoading().toString();
                        Object object3 = Predef$.MODULE$.refArrayOps((Object[])uriString.split("\\."));
                        String string = ext = (String)ArrayOps$.MODULE$.last$extension(object3);
                        String string2 = "xsd";
                        boolean isXSDExt = !(string != null ? !string.equals(string2) : string2 != null);
                        try {
                            Path path = Paths.get(this.uri());
                            File f = path.toFile();
                            tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)isXSDExt), (Object)f, (Object)BoxesRunTime.boxToLong((long)f.lastModified()));
                        }
                        catch (FileSystemNotFoundException e) {
                            tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)isXSDExt), null, (Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        catch (UnsupportedOperationException e) {
                            tuple43 = tuple42 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)isXSDExt), null, (Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        if (tuple42 == null) {
                            throw new MatchError((Object)tuple42);
                        }
                        boolean isFile = BoxesRunTime.unboxToBoolean((Object)tuple42._1());
                        boolean isXSD_ = BoxesRunTime.unboxToBoolean((Object)tuple42._2());
                        File file = (File)tuple42._3();
                        long fileModTime = BoxesRunTime.unboxToLong((Object)tuple42._4());
                        tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isFile), (Object)BoxesRunTime.boxToBoolean((boolean)isXSD_), (Object)file, (Object)BoxesRunTime.boxToLong((long)fileModTime));
                        object2 = tuple4 == null ? LazyVals.NullValue$.MODULE$ : tuple4;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.$1$$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return tuple4;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isFile() {
        return BoxesRunTime.unboxToBoolean((Object)this.$1$()._1());
    }

    public boolean isXSD_() {
        return BoxesRunTime.unboxToBoolean((Object)this.$1$()._2());
    }

    public File file() {
        return (File)this.$1$()._3();
    }

    public long fileModTime() {
        return BoxesRunTime.unboxToLong((Object)this.$1$()._4());
    }

    @Override
    public InputSource newInputSource() {
        this.fileModTime();
        InputSource is = new InputSource(this.url().openStream());
        is.setSystemId(this.uri().toString());
        return is;
    }

    @Override
    public URI uriForLoading() {
        return this.uri();
    }

    @Override
    public File diagnosticFile() {
        return this.diagnosticFilepath;
    }

    public boolean isNewerThan(URISchemaSource other) {
        if (this.isFile() && other.isFile()) {
            long otherTime;
            long thisTime = this.fileModTime();
            return thisTime > (otherTime = other.fileModTime());
        }
        return false;
    }
}

