/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.calendar;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import org.apache.daffodil.lib.calendar.DFDLCalendar;
import org.apache.daffodil.lib.calendar.DFDLCalendarOrder$;
import org.apache.daffodil.lib.calendar.DFDLDateTime$;
import org.apache.daffodil.lib.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.lib.calendar.ToDateMixin;
import org.apache.daffodil.lib.calendar.ToDateTimeMixin;
import org.apache.daffodil.lib.calendar.ToTimeMixin;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Enumeration;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class DFDLDateTime
extends DFDLCalendar
implements ToDateTimeMixin,
ToDateMixin,
ToTimeMixin,
Product {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DFDLDateTime.class.getDeclaredField("normalizedCalendar$lzy1"));
    private final Calendar calendar;
    private final boolean hasTimeZone;
    private volatile Object normalizedCalendar$lzy1;

    public static DFDLDateTime apply(Calendar calendar, boolean bl) {
        return DFDLDateTime$.MODULE$.apply(calendar, bl);
    }

    public static DFDLDateTime fromProduct(Product product) {
        return DFDLDateTime$.MODULE$.fromProduct(product);
    }

    public static DFDLDateTime unapply(DFDLDateTime dFDLDateTime) {
        return DFDLDateTime$.MODULE$.unapply(dFDLDateTime);
    }

    public DFDLDateTime(Calendar calendar, boolean hasTimeZone) {
        this.calendar = calendar;
        this.hasTimeZone = hasTimeZone;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.calendar()));
        n = Statics.mix((int)n, (int)(this.hasTimeZone() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public boolean canEqual(Object that) {
        return that instanceof DFDLDateTime;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "DFDLDateTime";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToBoolean((boolean)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "calendar";
        }
        if (1 == n2) {
            return "hasTimeZone";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public Calendar calendar() {
        return this.calendar;
    }

    @Override
    public boolean hasTimeZone() {
        return this.hasTimeZone;
    }

    public String toString() {
        return DFDLDateTimeConversion$.MODULE$.toXMLString(this);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof DFDLDateTime) {
            DFDLDateTime that = (DFDLDateTime)object;
            return this.dateTimeEqual(this, that);
        }
        throw Assert$.MODULE$.invariantFailed("xs:dateTime can only ever be compared with xs:dateTime");
    }

    public boolean $greater(DFDLDateTime that) {
        return this.dateTimeGreaterThan(this, that);
    }

    public boolean $less(DFDLDateTime that) {
        return this.dateTimeLessThan(this, that);
    }

    public boolean $greater$eq(DFDLDateTime that) {
        return !this.dateTimeLessThan(this, that);
    }

    public boolean $less$eq(DFDLDateTime that) {
        return !this.dateTimeGreaterThan(this, that);
    }

    public Calendar normalizedCalendar() {
        Object object = this.normalizedCalendar$lzy1;
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Calendar)this.normalizedCalendar$lzyINIT1();
    }

    private Object normalizedCalendar$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.normalizedCalendar$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Calendar calendar = null;
                    try {
                        calendar = this.normalizeCalendar(this.calendar());
                        object2 = calendar == null ? LazyVals.NullValue$.MODULE$ : calendar;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.normalizedCalendar$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return calendar;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DFDLDateTime getDateTimePlusFourteenHours() {
        if (this.hasTimeZone()) {
            throw Assert$.MODULE$.abort("Invariant broken: DFDLDateTime.this.hasTimeZone.unary_!");
        }
        Calendar adjustedCal = this.adjustTimeZone(this.normalizedCalendar(), 14, 0);
        DFDLDateTime dt = DFDLDateTime$.MODULE$.apply(adjustedCal, this.hasTimeZone());
        return dt;
    }

    public DFDLDateTime getDateTimeMinusFourteenHours() {
        if (this.hasTimeZone()) {
            throw Assert$.MODULE$.abort("Invariant broken: DFDLDateTime.this.hasTimeZone.unary_!");
        }
        Calendar adjustedCal = this.adjustTimeZone(this.normalizedCalendar(), -14, 0);
        DFDLDateTime dt = DFDLDateTime$.MODULE$.apply(adjustedCal, this.hasTimeZone());
        return dt;
    }

    public Calendar normalizeCalendar(Calendar cal) {
        Calendar newCal;
        block3: {
            block2: {
                newCal = (Calendar)cal.clone();
                TimeZone timeZone = cal.getTimeZone();
                TimeZone timeZone2 = TimeZone.GMT_ZONE;
                if (!(timeZone == null ? timeZone2 != null : !timeZone.equals(timeZone2))) break block2;
                TimeZone timeZone3 = cal.getTimeZone();
                TimeZone timeZone4 = TimeZone.UNKNOWN_ZONE;
                if (timeZone3 != null ? !timeZone3.equals(timeZone4) : timeZone4 != null) break block3;
            }
            return newCal;
        }
        int offset = newCal.get(15) * -1;
        newCal.clear(15);
        newCal.setTimeZone(TimeZone.GMT_ZONE);
        newCal.add(14, offset);
        newCal.getTime();
        return newCal;
    }

    public Calendar adjustTimeZone(Calendar cal, int hours, int minutes) {
        Calendar newCal = (Calendar)cal.clone();
        newCal.add(11, hours);
        newCal.add(12, minutes);
        newCal.getTime();
        return newCal;
    }

    public DFDLDateTime getNormalizedCalendar() {
        return DFDLDateTime$.MODULE$.apply((Calendar)this.normalizedCalendar().clone(), this.hasTimeZone());
    }

    private boolean dateTimeEqual(Object v1, Object v2) {
        DFDLDateTime p = (DFDLDateTime)v1;
        DFDLDateTime q = (DFDLDateTime)v2;
        Enumeration.Value value = this.order(p, q);
        Enumeration.Value value2 = DFDLCalendarOrder$.MODULE$.P_EQUAL_Q();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private boolean dateTimeLessThan(Object v1, Object v2) {
        DFDLDateTime p = (DFDLDateTime)v1;
        DFDLDateTime q = (DFDLDateTime)v2;
        Enumeration.Value value = this.order(p, q);
        Enumeration.Value value2 = DFDLCalendarOrder$.MODULE$.P_LESS_THAN_Q();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private boolean dateTimeGreaterThan(Object v1, Object v2) {
        DFDLDateTime p = (DFDLDateTime)v1;
        DFDLDateTime q = (DFDLDateTime)v2;
        Enumeration.Value value = this.order(p, q);
        Enumeration.Value value2 = DFDLCalendarOrder$.MODULE$.P_GREATER_THAN_Q();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public DFDLDateTime copy(Calendar calendar, boolean hasTimeZone) {
        return new DFDLDateTime(calendar, hasTimeZone);
    }

    public Calendar copy$default$1() {
        return this.calendar();
    }

    public boolean copy$default$2() {
        return this.hasTimeZone();
    }

    public Calendar _1() {
        return this.calendar();
    }

    public boolean _2() {
        return this.hasTimeZone();
    }
}

