/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;

public class BitsCharsetDecoderUTF16LE
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte2 = this.getByte(dis, 0);
        int byte1 = this.getByte(dis, 8);
        int high = byte1 << 8 | byte2;
        if (high >= 55296 && high <= 57343) {
            if (high >= 56320) {
                throw new BitsCharsetDecoderMalformedException(16);
            }
            int byte4 = this.getByte(dis, 16);
            int byte3 = this.getByte(dis, 24);
            int low = byte3 << 8 | byte4;
            if (low < 56320 || low > 57343) {
                throw new BitsCharsetDecoderMalformedException(32);
            }
            this.setLowSurrogate((char)low);
        }
        return (char)high;
    }
}

