/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.nio.CharBuffer;
import java.nio.LongBuffer;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIteratorState;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public class InputSourceDataInputStreamCharIterator
implements IterableOnce,
IterableOnceOps,
Iterator,
DataInputStream.CharIterator {
    private final InputSourceDataInputStream dis;
    private FormatInfo finfo;

    public InputSourceDataInputStreamCharIterator(InputSourceDataInputStream dis) {
        this.dis = dis;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.finfo = null;
    }

    @Override
    public void reset() {
        this.dis.cst().charIteratorState().clear();
        if (this.finfo != null) {
            this.finfo.decoder().reset();
            this.finfo = null;
            return;
        }
    }

    @Override
    public void setFormatInfo(FormatInfo _finfo) {
        this.finfo = _finfo;
    }

    private void checkNeedsRefetch() {
        InputSourceDataInputStreamCharIteratorState cis = this.dis.cst().charIteratorState();
        if (cis.bitPositionAtLastFetch0b() != this.dis.bitPos0b()) {
            this.dis.cst().charIteratorState().clear();
            this.dis.cst().charIteratorState().bitPositionAtLastFetch0b_$eq(this.dis.bitPos0b());
            return;
        }
    }

    private void fetch() {
        InputSourceDataInputStreamCharIteratorState cis = this.dis.cst().charIteratorState();
        if (cis.moreDataAvailable()) {
            long startingBitPos = this.dis.bitPos0b();
            if (!this.dis.align(this.finfo.encodingMandatoryAlignmentInBits(), this.finfo)) {
                cis.moreDataAvailable_$eq(false);
                return;
            }
            CharBuffer decodedChars = cis.decodedChars();
            LongBuffer bitPositions = cis.bitPositions();
            if (bitPositions.limit() > 0) {
                long lastFetchBitPositionEnd = bitPositions.get(bitPositions.limit() - 1);
                this.dis.setBitPos0b(lastFetchBitPositionEnd);
            }
            decodedChars.compact();
            bitPositions.compact();
            int numDecoded = this.finfo.decoder().decode(this.dis, this.finfo, decodedChars, bitPositions);
            decodedChars.flip();
            bitPositions.flip();
            if (numDecoded == 0) {
                cis.moreDataAvailable_$eq(false);
            }
            this.dis.setBitPos0b(startingBitPos);
            return;
        }
    }

    @Override
    public char peek() {
        this.checkNeedsRefetch();
        CharBuffer decodedChars = this.dis.cst().charIteratorState().decodedChars();
        if (decodedChars.remaining() >= 1) {
            return decodedChars.get(decodedChars.position());
        }
        if (this.dis.cst().charIteratorState().moreDataAvailable()) {
            this.fetch();
            return this.peek();
        }
        return (char)-1;
    }

    @Override
    public char peek2() {
        this.checkNeedsRefetch();
        CharBuffer decodedChars = this.dis.cst().charIteratorState().decodedChars();
        if (decodedChars.remaining() >= 2) {
            return decodedChars.get(decodedChars.position() + 1);
        }
        if (this.dis.cst().charIteratorState().moreDataAvailable()) {
            this.fetch();
            return this.peek2();
        }
        return (char)-1;
    }

    public boolean hasNext() {
        return this.peek() != (char)-1;
    }

    public char next() {
        if (!this.hasNext()) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStreamCharIterator.this.hasNext");
        }
        InputSourceDataInputStreamCharIteratorState cis = this.dis.cst().charIteratorState();
        char c = cis.decodedChars().get();
        long pos = cis.bitPositions().get();
        this.dis.setBitPos0b(pos);
        cis.bitPositionAtLastFetch0b_$eq(pos);
        return c;
    }
}

