/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLRuntimeException;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilderFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(XMLObjectBuilderFactory.class);
    @Nonnull
    private final Map<QName, XMLObjectBuilder<?>> builders = new ConcurrentHashMap();

    @Nullable
    public XMLObjectBuilder<?> getBuilder(@Nonnull QName key) {
        return this.builders.get(key);
    }

    @Nullable
    public XMLObjectBuilder<?> getBuilder(@Nonnull Element domElement) {
        XMLObjectBuilder<?> builder = null;
        QName xsitype = DOMTypeSupport.getXSIType((Element)domElement);
        if (xsitype != null) {
            builder = this.getBuilder(xsitype);
        }
        if (builder == null) {
            builder = this.getBuilder(QNameSupport.getNodeQName((Node)domElement));
        }
        return builder;
    }

    @Nonnull
    public <XMLObjectType extends XMLObject> XMLObjectBuilder<XMLObjectType> ensureBuilder(@Nonnull QName key) {
        XMLObjectBuilder<?> builder = this.getBuilder(key);
        if (builder == null) {
            throw new XMLRuntimeException("Unable to locate a builder for " + String.valueOf(key));
        }
        return builder;
    }

    @Nonnull
    public <XMLObjectType extends XMLObject> XMLObjectBuilder<XMLObjectType> ensureBuilder(@Nonnull Element domElement) {
        XMLObjectBuilder<?> builder = this.getBuilder(domElement);
        if (builder == null) {
            throw new XMLRuntimeException("Unable to locate a builder for " + domElement.getLocalName());
        }
        return builder;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<QName, XMLObjectBuilder<?>> getBuilders() {
        return CollectionSupport.copyToMap(this.builders);
    }

    public void registerBuilder(@Nonnull QName builderKey, @Nonnull XMLObjectBuilder<?> builder) {
        Constraint.isNotNull((Object)builderKey, (String)"Builder key cannot be null");
        Constraint.isNotNull(builder, (String)"Builder cannot be null");
        this.log.debug("Registering builder {} under key {}", (Object)builder.getClass().getName(), (Object)builderKey);
        this.builders.put(builderKey, builder);
    }

    @Nullable
    public XMLObjectBuilder<?> deregisterBuilder(@Nonnull QName builderKey) {
        Constraint.isNotNull((Object)builderKey, (String)"Builder key QName cannot be null");
        this.log.debug("Deregistering builder for object type {}", (Object)builderKey);
        return this.builders.remove(builderKey);
    }
}

