/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class RemoteHttpCacheFactoryUnitTest
extends TestCase {
    public void testCreateRemoteHttpCacheClient_Bad() {
        String remoteHttpClientClassName = "junk";
        RemoteHttpCacheAttributes cattr = new RemoteHttpCacheAttributes();
        cattr.setRemoteHttpClientClassName("junk");
        RemoteHttpCacheFactory factory = new RemoteHttpCacheFactory();
        IRemoteHttpCacheClient result = factory.createRemoteHttpCacheClientForAttributes(cattr);
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have a cache.", (Object)result);
        RemoteHttpCacheFactoryUnitTest.assertTrue((String)"Wrong default.", (boolean)(result instanceof RemoteHttpCacheClient));
        RemoteHttpCacheFactoryUnitTest.assertTrue((String)"Should be initialized", (boolean)((RemoteHttpCacheClient)result).isInitialized());
    }

    public void testCreateRemoteHttpCacheClient_default() {
        RemoteHttpCacheAttributes cattr = new RemoteHttpCacheAttributes();
        RemoteHttpCacheFactory factory = new RemoteHttpCacheFactory();
        IRemoteHttpCacheClient result = factory.createRemoteHttpCacheClientForAttributes(cattr);
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have a cache.", (Object)result);
        RemoteHttpCacheFactoryUnitTest.assertTrue((String)"Wrong default.", (boolean)(result instanceof RemoteHttpCacheClient));
    }

    public void testGetCache_normal() {
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have a manager.", (Object)cacheMgr);
        ICacheEventLogger cacheEventLogger = null;
        IElementSerializer elementSerializer = null;
        RemoteHttpCacheAttributes cattr = new RemoteHttpCacheAttributes();
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have attributes.", (Object)cattr);
        RemoteHttpCacheFactory factory = new RemoteHttpCacheFactory();
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have a factory.", (Object)factory);
        AuxiliaryCache result = factory.createCache((AuxiliaryCacheAttributes)cattr, (ICompositeCacheManager)cacheMgr, cacheEventLogger, elementSerializer);
        RemoteHttpCacheFactoryUnitTest.assertNotNull((String)"Should have a cache.", (Object)result);
    }
}

