/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingDatabaseMetaData;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegatingDatabaseMetaData {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingDatabaseMetaData meta = null;
    private DatabaseMetaData delegateMeta = null;

    @Before
    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.delegateMeta = this.delegateConn.getMetaData();
        this.conn = new DelegatingConnection(this.delegateConn);
        this.meta = new DelegatingDatabaseMetaData(this.conn, this.delegateMeta);
    }

    @Test
    public void testGetDelegate() throws Exception {
        Assert.assertEquals((Object)this.delegateMeta, (Object)this.meta.getDelegate());
    }

    @Test
    public void testCheckOpen() throws Exception {
        ResultSet rst = this.meta.getSchemas();
        Assert.assertTrue((!rst.isClosed() ? 1 : 0) != 0);
        this.conn.close();
        Assert.assertTrue((boolean)rst.isClosed());
    }
}

