/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Comparator;
import org.apache.commons.collections4.ComparatorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComparatorUtilsTest {
    @Test
    public void testBooleanComparator() {
        Comparator comp = ComparatorUtils.booleanComparator((boolean)true);
        Assertions.assertTrue((comp.compare(Boolean.TRUE, Boolean.FALSE) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.TRUE, Boolean.TRUE));
        Assertions.assertTrue((comp.compare(Boolean.FALSE, Boolean.TRUE) > 0 ? 1 : 0) != 0);
        comp = ComparatorUtils.booleanComparator((boolean)false);
        Assertions.assertTrue((comp.compare(Boolean.TRUE, Boolean.FALSE) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.TRUE, Boolean.TRUE));
        Assertions.assertTrue((comp.compare(Boolean.FALSE, Boolean.TRUE) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChainedComparator() {
        Comparator comp = ComparatorUtils.chainedComparator((Comparator[])new Comparator[]{ComparatorUtils.naturalComparator(), ComparatorUtils.naturalComparator()});
        Assertions.assertTrue((comp.compare(1, 2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)comp.compare(1, 1));
        Assertions.assertTrue((comp.compare(2, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMax() {
        Comparator reversed = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Assertions.assertEquals((Integer)10, (Integer)((Integer)ComparatorUtils.max((Object)1, (Object)10, null)));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)ComparatorUtils.max((Object)10, (Object)-10, null)));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)ComparatorUtils.max((Object)1, (Object)10, (Comparator)reversed)));
        Assertions.assertEquals((Integer)-10, (Integer)((Integer)ComparatorUtils.max((Object)10, (Object)-10, (Comparator)reversed)));
        Assertions.assertThrows(NullPointerException.class, () -> ComparatorUtils.max((Object)1, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> ComparatorUtils.max(null, (Object)10, null));
    }

    @Test
    public void testMin() {
        Comparator reversed = ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)ComparatorUtils.min((Object)1, (Object)10, null)));
        Assertions.assertEquals((Integer)-10, (Integer)((Integer)ComparatorUtils.min((Object)10, (Object)-10, null)));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)ComparatorUtils.min((Object)1, (Object)10, (Comparator)reversed)));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)ComparatorUtils.min((Object)10, (Object)-10, (Comparator)reversed)));
        Assertions.assertThrows(NullPointerException.class, () -> ComparatorUtils.min((Object)1, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> ComparatorUtils.min(null, (Object)10, null));
    }

    @Test
    public void testNullHighComparator() {
        Comparator comp = ComparatorUtils.nullHighComparator(null);
        Assertions.assertTrue((comp.compare(null, 10) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)comp.compare(null, null));
        Assertions.assertTrue((comp.compare(10, null) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullLowComparator() {
        Comparator comp = ComparatorUtils.nullLowComparator(null);
        Assertions.assertTrue((comp.compare(null, 10) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)comp.compare(null, null));
        Assertions.assertTrue((comp.compare(10, null) > 0 ? 1 : 0) != 0);
    }
}

