/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.moshi.internal.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class RecordJsonAdapter<T>
extends JsonAdapter<T> {
    static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            MethodHandle constructor;
            if (!annotations.isEmpty()) {
                return null;
            }
            if (!(type instanceof Class) && !(type instanceof ParameterizedType)) {
                return null;
            }
            Class<?> rawType = Types.getRawType(type);
            if (!rawType.isRecord()) {
                return null;
            }
            RecordComponent[] components = rawType.getRecordComponents();
            LinkedHashMap bindings = new LinkedHashMap();
            Class[] componentRawTypes = new Class[components.length];
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            for (RecordComponent component : components) {
                componentRawTypes[i] = component.getType();
                ComponentBinding<Object> componentBinding = 1.createComponentBinding(type, rawType, moshi, lookup, component);
                ComponentBinding<Object> replaced = bindings.put(componentBinding.jsonName, componentBinding);
                if (replaced == null) continue;
                throw new IllegalArgumentException("Conflicting components:\n    " + replaced.componentName + "\n    " + componentBinding.componentName);
            }
            try {
                constructor = lookup.findConstructor(rawType, MethodType.methodType(Void.TYPE, componentRawTypes));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            return new RecordJsonAdapter(constructor, rawType.getSimpleName(), bindings).nullSafe();
        }

        private static ComponentBinding<Object> createComponentBinding(Type type, Class<?> rawType, Moshi moshi, MethodHandles.Lookup lookup, RecordComponent component) {
            MethodHandle accessor;
            String componentName = component.getName();
            String jsonName = Util.jsonName(componentName, component);
            Type componentType = Util.resolve(type, rawType, component.getGenericType());
            Set<? extends Annotation> qualifiers = Util.jsonAnnotations(component);
            JsonAdapter adapter = moshi.adapter(componentType, qualifiers);
            try {
                accessor = lookup.unreflect(component.getAccessor());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            return new ComponentBinding<Object>(componentName, jsonName, adapter, accessor);
        }
    };
    private final String targetClass;
    private final MethodHandle constructor;
    private final ComponentBinding<Object>[] componentBindingsArray;
    private final JsonReader.Options options;

    public RecordJsonAdapter(MethodHandle constructor, String targetClass, Map<String, ComponentBinding<?>> componentBindings) {
        this.constructor = constructor;
        this.targetClass = targetClass;
        this.componentBindingsArray = componentBindings.values().toArray(new ComponentBinding[componentBindings.size()]);
        this.options = JsonReader.Options.of(componentBindings.keySet().toArray(new String[componentBindings.size()]));
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        Object[] resultsArray = new Object[this.componentBindingsArray.length];
        reader.beginObject();
        while (reader.hasNext()) {
            int index = reader.selectName(this.options);
            if (index == -1) {
                reader.skipName();
                reader.skipValue();
                continue;
            }
            resultsArray[index] = this.componentBindingsArray[index].adapter.fromJson(reader);
        }
        reader.endObject();
        try {
            return (T)this.constructor.invokeWithArguments(resultsArray);
        }
        catch (InvocationTargetException e) {
            throw Util.rethrowCause(e);
        }
        catch (Throwable e) {
            int limit = this.componentBindingsArray.length;
            for (int i = 0; i < limit; ++i) {
                if (resultsArray[i] != null || !((Class)this.componentBindingsArray[i].accessor.type().returnType()).isPrimitive()) continue;
                throw Util.missingProperty(this.componentBindingsArray[i].componentName, this.componentBindingsArray[i].jsonName, reader);
            }
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.beginObject();
        for (ComponentBinding<Object> binding : this.componentBindingsArray) {
            Object componentValue;
            writer.name(binding.jsonName);
            try {
                componentValue = binding.accessor.invoke(value);
            }
            catch (InvocationTargetException e) {
                throw Util.rethrowCause(e);
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
            binding.adapter.toJson(writer, componentValue);
        }
        writer.endObject();
    }

    public String toString() {
        return "JsonAdapter(" + this.targetClass + ")";
    }

    private record ComponentBinding<T>(String componentName, String jsonName, JsonAdapter<T> adapter, MethodHandle accessor) {
    }
}

