/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportConfiguration {
    private static final int WORKERS_CORE_THREADS = 20;
    private static final int WORKERS_MAX_THREADS = 100;
    private static final int WORKER_KEEP_ALIVE = 5;
    private static final int BLOCKING_QUEUE_LENGTH = -1;
    private static final String S_T_CORE = "snd_t_core";
    private static final String S_T_MAX = "snd_t_max";
    private static final String S_T_ALIVE = "snd_alive_sec";
    private static final String S_T_QLEN = "snd_qlen";
    private static final String C_T_CORE = "lst_t_core";
    private static final String C_T_MAX = "lst_t_max";
    private static final String C_T_ALIVE = "lst_alive_sec";
    private static final String C_T_QLEN = "lst_qlen";
    private static final Log log = LogFactory.getLog(TransportConfiguration.class);
    private static Map<String, TransportConfiguration> _configurations = new HashMap<String, TransportConfiguration>();
    private Properties props;

    private TransportConfiguration(String transportName) {
        try {
            this.props = BaseUtils.loadProperties(transportName + ".properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static TransportConfiguration getConfiguration(String transportName) {
        if (_configurations.containsKey(transportName)) {
            return _configurations.get(transportName);
        }
        TransportConfiguration config = new TransportConfiguration(transportName);
        _configurations.put(transportName, config);
        return config;
    }

    public int getServerCoreThreads() {
        return this.getProperty(S_T_CORE, 20);
    }

    public int getServerMaxThreads() {
        return this.getProperty(S_T_MAX, 100);
    }

    public int getServerKeepalive() {
        return this.getProperty(S_T_ALIVE, 5);
    }

    public int getServerQueueLen() {
        return this.getProperty(S_T_QLEN, -1);
    }

    public int getClientCoreThreads() {
        return this.getProperty(C_T_CORE, 20);
    }

    public int getClientMaxThreads() {
        return this.getProperty(C_T_MAX, 100);
    }

    public int getClientKeepalive() {
        return this.getProperty(C_T_ALIVE, 5);
    }

    public int getClientQueueLen() {
        return this.getProperty(C_T_QLEN, -1);
    }

    public int getProperty(String name, int def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Integer.valueOf(val) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using transport tuning parameter : " + name + " = " + val));
            }
            return Integer.valueOf(val);
        }
        return def;
    }

    public boolean getBooleanValue(String name, boolean def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Boolean.parseBoolean(val)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using transport tuning parameter : " + name));
            }
            return true;
        }
        return def;
    }
}

