/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.BooleanAttr;
import org.apache.woden.xml.StringAttr;

public class HTTPBindingExtensionsImpl
extends BaseComponentExtensionContext
implements HTTPBindingExtensions {
    public HTTPBindingExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("http method default"), this.getProperty("http query parameter separator default"), this.getProperty("http cookies"), this.getProperty("http content encoding default")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("http method default".equals(propertyName)) {
            return this.newExtensionProperty("http method default", this.getHttpMethodDefault());
        }
        if ("http query parameter separator default".equals(propertyName)) {
            return this.newExtensionProperty("http query parameter separator default", this.getHttpQueryParameterSeparatorDefault());
        }
        if ("http cookies".equals(propertyName)) {
            return this.newExtensionProperty("http cookies", this.isHttpCookies());
        }
        if ("http content encoding default".equals(propertyName)) {
            return this.newExtensionProperty("http content encoding default", this.getHttpContentEncodingDefault());
        }
        return null;
    }

    public String getHttpMethodDefault() {
        StringAttr methodDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_METHOD_DEFAULT);
        return methodDef != null ? methodDef.getString() : null;
    }

    public String getHttpQueryParameterSeparatorDefault() {
        StringAttr qpsDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR_DEFAULT);
        return qpsDef != null ? qpsDef.getString() : "&";
    }

    public Boolean isHttpCookies() {
        BooleanAttr cookiesUsed = (BooleanAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_COOKIES);
        return cookiesUsed != null ? cookiesUsed.getBoolean() : new Boolean(false);
    }

    public String getHttpContentEncodingDefault() {
        StringAttr ceDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
        return ceDef != null ? ceDef.getString() : null;
    }
}

