/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.RelationalOperator;

public class GreaterThanOrEqualsOperator
extends RelationalOperator {
    public static final GreaterThanOrEqualsOperator SINGLETON = new GreaterThanOrEqualsOperator();

    @Override
    public String getOperatorSymbol() {
        return ">=";
    }

    @Override
    public Object apply(Object pLeft, Object pRight, Object pContext, Logger pLogger) throws ELException {
        if (pLeft == pRight) {
            return Boolean.TRUE;
        }
        if (pLeft == null || pRight == null) {
            return Boolean.FALSE;
        }
        return super.apply(pLeft, pRight, pContext, pLogger);
    }

    @Override
    public boolean apply(double pLeft, double pRight, Logger pLogger) {
        return pLeft >= pRight;
    }

    @Override
    public boolean apply(long pLeft, long pRight, Logger pLogger) {
        return pLeft >= pRight;
    }

    @Override
    public boolean apply(String pLeft, String pRight, Logger pLogger) {
        return pLeft.compareTo(pRight) >= 0;
    }
}

