/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Objects;
import org.apache.wicket.markup.head.AbstractCssReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;

public class CssUrlReferenceHeaderItem
extends AbstractCssReferenceHeaderItem {
    private static final long serialVersionUID = 1L;
    private final String url;

    public CssUrlReferenceHeaderItem(String url, String media, String rel) {
        super(media, rel);
        this.url = url;
    }

    public CssUrlReferenceHeaderItem(String url, String media) {
        super(media, null);
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()));
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()) + "-" + this.getMedia());
    }

    public String toString() {
        return "CSSUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.getMedia() != null ? this.getMedia().hashCode() : 0);
        result = 31 * result + (this.getRel() != null ? this.getRel().hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssUrlReferenceHeaderItem that = (CssUrlReferenceHeaderItem)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.getMedia(), that.getMedia()) && Objects.equals(this.getRel(), that.getRel());
    }
}

