/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.service.advice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorFactory;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorInvocationHandler;
import org.apache.fulcrum.yaafi.framework.util.Validate;
import org.apache.fulcrum.yaafi.service.advice.AdviceService;

public class AdviceServiceImpl
extends AbstractLogEnabled
implements AdviceService,
Serviceable,
Contextualizable,
Reconfigurable {
    private ServiceManager serviceManager;
    private String[] defaultInterceptorList;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
    }

    public void contextualize(Context context) throws ContextException {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] interceptorConfigList = configuration.getChild("interceptors").getChildren("interceptor");
        this.defaultInterceptorList = new String[interceptorConfigList.length];
        for (int i = 0; i < interceptorConfigList.length; ++i) {
            this.defaultInterceptorList[i] = interceptorConfigList[i].getValue();
        }
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.configure(configuration);
    }

    @Override
    public Object advice(Object object) {
        Validate.notNull(object, "object");
        return this.advice(this.getDefaultInterceptorList(), object);
    }

    @Override
    public Object advice(String name, Object object) {
        Validate.notNull(object, "object");
        return this.doAdvice(name, this.getDefaultInterceptorList(), object);
    }

    @Override
    public Object advice(String[] interceptorList, Object object) {
        Validate.notNull(object, "object");
        String className = object.getClass().getName();
        return this.doAdvice(className, interceptorList, object);
    }

    @Override
    public Object advice(String name, String[] interceptorList, Object object) {
        Validate.notNull(object, "object");
        return this.doAdvice(name, interceptorList, object);
    }

    @Override
    public boolean isAdviced(Object object) {
        InvocationHandler invocationHandler = null;
        if (object != null && Proxy.isProxyClass(object.getClass())) {
            invocationHandler = Proxy.getInvocationHandler(object);
            return invocationHandler instanceof AvalonInterceptorInvocationHandler;
        }
        return false;
    }

    protected Object doAdvice(String name, String[] interceptorList, Object object) {
        Validate.notEmpty(name, "name");
        Validate.notNull(interceptorList, "interceptorList");
        Validate.notNull(object, "object");
        Object result = null;
        String clazzName = object.getClass().getName();
        if (interceptorList.length == 0) {
            if (this.getLogger().isInfoEnabled()) {
                String msg = "Skipping creation of dynamic proxy since no interceptors are requested : " + name;
                this.getLogger().info(msg);
            }
            return object;
        }
        if (this.isAdviced(object)) {
            if (this.getLogger().isInfoEnabled()) {
                String msg = "Skipping creation of dynamic proxy since it is already advised : " + name;
                this.getLogger().info(msg);
            }
            return object;
        }
        try {
            result = AvalonInterceptorFactory.create(clazzName, name, this.getServiceManager(), interceptorList, object);
        }
        catch (ServiceException e) {
            String msg = "Unable to advice the object : " + name;
            this.getLogger().error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    private ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    private String[] getDefaultInterceptorList() {
        return this.defaultInterceptorList;
    }
}

