/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.IntakeError;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.Rule;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.fulcrum.parser.ValueParser;

public abstract class Field<T>
implements Serializable,
LogEnabled {
    private static final long serialVersionUID = 6897267716698096895L;
    private static final String EMPTY = "";
    private static final String VALUE_IF_ABSENT_KEY = "_vifa_";
    public static final String defaultValidatorPackage = "org.apache.fulcrum.intake.validator.";
    public static final String defaultFieldPackage = "org.apache.fulcrum.intake.model.";
    private final String name;
    private final String key;
    private final String displaySize;
    protected String mapToObject;
    private String mapToProperty;
    private String validatorClassName;
    private transient Validator<T> validator;
    private Method getter;
    private Method setter;
    private String ifRequiredMessage;
    private final boolean isMultiValued;
    private final Group group;
    private boolean alwaysRequired;
    protected T defaultValue;
    protected T emptyValue;
    private String displayName;
    private String maxSize;
    private boolean setFlag;
    private boolean validFlag;
    private boolean validated;
    private boolean required;
    private boolean initialized;
    private String message;
    private Retrievable retrievable;
    private Locale locale;
    private String stringValue;
    private String[] stringValues;
    private T validValue;
    private Object testValue;
    private final Object[] valArray;
    protected ValueParser parser;
    private Map<String, Rule> ruleMap;
    protected transient Logger log;

    public Field(XmlField field, Group group) throws IntakeException {
        Rule maxLengthRule;
        this.enableLogging(field.getLogger());
        this.group = group;
        this.key = field.getKey();
        this.name = field.getName();
        this.displayName = field.getDisplayName();
        this.displaySize = field.getDisplaySize();
        this.isMultiValued = field.isMultiValued();
        this.ruleMap = field.getRuleMap();
        try {
            this.setDefaultValue(field.getDefaultValue());
        }
        catch (RuntimeException e) {
            this.log.error("Could not set default value of " + this.getDisplayName() + " to " + field.getDefaultValue(), (Throwable)e);
        }
        try {
            this.setEmptyValue(field.getEmptyValue());
        }
        catch (RuntimeException e) {
            this.log.error("Could not set empty value of " + this.getDisplayName() + " to " + field.getEmptyValue(), (Throwable)e);
        }
        this.validatorClassName = field.getValidator();
        if (this.validatorClassName == null) {
            this.validatorClassName = this.getDefaultValidator();
        } else if (this.validatorClassName.indexOf(46) == -1) {
            this.validatorClassName = defaultValidatorPackage + this.validatorClassName;
        }
        Rule reqRule = field.getRuleMap().get("required");
        if (reqRule != null) {
            this.alwaysRequired = Boolean.valueOf(reqRule.getValue());
            this.ifRequiredMessage = reqRule.getMessage();
        }
        if ((maxLengthRule = field.getRuleMap().get("maxLength")) != null) {
            this.maxSize = maxLengthRule.getValue();
        }
        this.mapToObject = field.getMapToObject();
        this.mapToProperty = field.getMapToProperty();
        this.valArray = new Object[1];
    }

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger(this.getClass().getSimpleName());
    }

    public void initGetterAndSetter() {
        Method tmpGetter = null;
        Method tmpSetter = null;
        if (StringUtils.isNotEmpty((CharSequence)this.mapToObject) && StringUtils.isNotEmpty((CharSequence)this.mapToProperty)) {
            try {
                tmpGetter = IntakeServiceFacade.getFieldGetter(this.mapToObject, this.mapToProperty);
            }
            catch (Exception e) {
                this.log.error("IntakeService could not map the getter for field " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName() + " to the property " + this.mapToProperty + " in object " + this.mapToObject, (Throwable)e);
            }
            try {
                tmpSetter = IntakeServiceFacade.getFieldSetter(this.mapToObject, this.mapToProperty);
            }
            catch (Exception e) {
                this.log.error("IntakeService could not map the setter for field " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName() + " to the property " + this.mapToProperty + " in object " + this.mapToObject, (Throwable)e);
            }
        }
        this.getter = tmpGetter;
        this.setter = tmpSetter;
    }

    public Field<T> init(ValueParser pp) throws IntakeException {
        this.parser = pp;
        this.setValid(true);
        this.setValidated(false);
        this.locale = pp.getLocale();
        if (pp.containsKey((Object)this.getKey())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": Found our Key in the request, setting Value");
            }
            if (pp.getString(this.getKey()) != null) {
                this.setFlag = true;
            }
        } else if (pp.containsKey((Object)this.getValueIfAbsent()) && pp.getString(this.getValueIfAbsent()) != null) {
            pp.add(this.getKey(), pp.getString(this.getValueIfAbsent()));
            this.setFlag = true;
        }
        this.initialized = true;
        return this;
    }

    public Field<T> init(Retrievable obj) {
        if (!this.initialized) {
            this.validFlag = true;
            this.validated = false;
        }
        this.retrievable = obj;
        return this;
    }

    public Group getGroup() {
        return this.group;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getDefaultValidator() {
        return DefaultValidator.class.getName();
    }

    public Validator<T> getValidator() {
        if (this.validator == null && this.validatorClassName != null) {
            try {
                this.validator = this.createValidator(this.validatorClassName);
            }
            catch (IntakeException e) {
                this.log.error("Could not create validator", (Throwable)e);
            }
        }
        return this.validator;
    }

    public String getMapToObject() {
        return this.mapToObject;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean isRequired() {
        return this.alwaysRequired || this.required;
    }

    public void setRequired(boolean v) {
        this.setRequired(v, this.ifRequiredMessage);
    }

    public void setRequired(boolean v, String message) {
        this.required = v;
        if (v && (!this.setFlag || null == this.getTestValue())) {
            this.validFlag = false;
            this.message = message;
        }
    }

    public void removeFromRequest() {
        this.parser.remove(this.getKey());
        this.parser.remove(this.getKey() + VALUE_IF_ABSENT_KEY);
    }

    public void dispose() {
        this.parser = null;
        this.initialized = false;
        this.setFlag = false;
        this.validFlag = false;
        this.validated = false;
        this.required = false;
        this.message = null;
        this.retrievable = null;
        this.locale = null;
        this.stringValue = null;
        this.stringValues = null;
        this.validValue = null;
        this.testValue = null;
        this.valArray[0] = null;
    }

    public String getKey() {
        return this.group == null ? this.key : this.group.getObjectKey() + this.key;
    }

    public String getValueIfAbsent() {
        return this.getKey() + VALUE_IF_ABSENT_KEY;
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public boolean isSet() {
        return this.setFlag;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    public String getMessage() {
        return this.message == null ? EMPTY : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.validFlag = false;
    }

    protected void setSet(boolean setFlag) {
        this.setFlag = setFlag;
    }

    protected void setValid(boolean validFlag) {
        this.validFlag = validFlag;
    }

    protected void setValidated(boolean validated) {
        this.validated = validated;
    }

    public boolean validate() {
        this.log.debug(this.name + ": validate()");
        Validator<T> v = this.getValidator();
        if (this.isMultiValued()) {
            this.stringValues = this.parser.getStrings(this.getKey());
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": Multi-Valued, Value is " + this.stringValue);
                if (this.stringValues != null) {
                    for (int i = 0; i < this.stringValues.length; ++i) {
                        this.log.debug(this.name + ": " + i + ". Value: " + this.stringValues[i]);
                    }
                }
            }
            if (v != null) {
                this.setTestValue(this.stringValues);
                try {
                    v.assertValidity(this);
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            }
            if (this.validFlag) {
                this.doSetValue();
            }
        } else {
            this.stringValue = this.parser.getString(this.getKey());
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": Single Valued, Value is " + this.stringValue);
            }
            if (v != null) {
                this.setTestValue(this.stringValue);
                try {
                    v.assertValidity(this);
                    this.log.debug(this.name + ": Value is ok");
                    this.doSetValue();
                }
                catch (ValidationException ve) {
                    this.log.debug(this.name + ": Value failed validation!");
                    this.setMessage(ve.getMessage());
                }
            } else {
                this.doSetValue();
            }
        }
        this.validated = true;
        return this.validFlag;
    }

    public abstract void setDefaultValue(String var1);

    public abstract void setEmptyValue(String var1);

    protected abstract void doSetValue();

    void setInitialValue(T obj) {
        this.validValue = obj;
    }

    public T getInitialValue() throws IntakeException {
        if (this.validValue == null) {
            if (this.retrievable != null) {
                this.getProperty(this.retrievable);
            } else {
                this.getDefault();
            }
        }
        return this.validValue;
    }

    void setTestValue(Object obj) {
        this.testValue = obj;
    }

    public <TT> TT getTestValue() {
        return (TT)this.testValue;
    }

    public T getValue() {
        T val = null;
        try {
            val = this.getInitialValue();
        }
        catch (IntakeException e) {
            this.log.error("Could not get intial value of " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName(), (Throwable)e);
        }
        if (this.getTestValue() != null) {
            val = (T)this.getTestValue();
        }
        return val;
    }

    public String toString() {
        String res = EMPTY;
        if (this.stringValue != null) {
            res = this.stringValue;
        } else if (this.getValue() != null) {
            res = this.getValue().toString();
        }
        return res;
    }

    public String getHTMLString() {
        String res = this.toString();
        return StringUtils.replace((String)res, (String)"\"", (String)"&quot;");
    }

    public void getProperty(Object obj) throws IntakeException {
        try {
            Object t = this.getter.invoke(obj, new Object[0]);
            this.validValue = t;
        }
        catch (IllegalAccessException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (IllegalArgumentException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (InvocationTargetException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
    }

    public void getDefault() {
        this.validValue = this.getDefaultValue();
    }

    public void setProperty(Object obj) throws IntakeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.name + ".setProperty(" + obj.getClass().getName() + ")");
        }
        if (!this.isValid()) {
            throw new IntakeException("Attempted to assign an invalid input.");
        }
        if (this.isSet() && null != this.getTestValue()) {
            this.valArray[0] = this.getTestValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": Property is set, value is " + String.valueOf(this.valArray[0]));
            }
        } else {
            this.valArray[0] = this.getSafeEmptyValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": Property is not set, using emptyValue " + String.valueOf(this.valArray[0]));
            }
        }
        try {
            if (this.setter != null) {
                this.setter.invoke(obj, this.valArray);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(this.name + ": has a null setter for the mapToProperty Attribute, although all Fields should be mapped to " + this.mapToObject + ". If this is unwanted, you should double check the mapToProperty Attribute, and consult the logs. The Turbine Intake Service will have logged a detailed Message with the error.");
            }
        }
        catch (IllegalAccessException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (IllegalArgumentException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (InvocationTargetException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
    }

    private void throwSetGetException(String type, Object obj, String fieldName, String groupName, Exception e) throws IntakeException {
        throw new IntakeException("Could not execute " + type + " method for " + fieldName + " in group " + groupName + " on " + obj.getClass().getName(), e);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getEmptyValue() {
        return this.emptyValue;
    }

    protected Object getSafeEmptyValue() {
        return this.getEmptyValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplaySize() {
        return StringUtils.isEmpty((CharSequence)this.displaySize) ? EMPTY : this.displaySize;
    }

    public String getMaxSize() {
        return StringUtils.isEmpty((CharSequence)this.maxSize) ? EMPTY : this.maxSize;
    }

    public String getStringValue() {
        return this.toString();
    }

    private Validator<T> createValidator(String validatorClassName) throws IntakeException {
        Validator v;
        try {
            v = (Validator)Class.forName(validatorClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IntakeException("Could not create new instance of Validator(" + validatorClassName + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new IntakeException("Could not create new instance of Validator(" + validatorClassName + ")", e);
        }
        catch (ClassNotFoundException e) {
            throw new IntakeException("Could not load Validator class(" + validatorClassName + ")", e);
        }
        if (v instanceof LogEnabled) {
            ((LogEnabled)v).enableLogging(this.log);
        }
        if (!(v instanceof InitableByConstraintMap)) {
            throw new IntakeError("All Validation objects must be subclasses of InitableByConstraintMap");
        }
        ((InitableByConstraintMap)((Object)v)).init(this.ruleMap);
        return v;
    }
}

