/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cli;

import com.google.gxp.compiler.Compiler;
import com.google.gxp.compiler.InvalidConfigException;
import com.google.gxp.compiler.alerts.AlertCounter;
import com.google.gxp.compiler.alerts.PrintingAlertSink;
import com.google.gxp.compiler.cli.GxpcFlags;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.SystemFileSystem;
import java.io.IOException;
import org.kohsuke.args4j.CmdLineException;

public class Gxpc {
    private static final String BANNER_STRIPE = Gxpc.makeStripe(79);
    public static final String GXPC_EMAIL_ADDRESS = "gxpc-eng@google.com";
    public static final String GXPC_BUG_BANNER = "\n" + BANNER_STRIPE + "\n" + "\n" + "  Looks like you found a bug in gxpc! Please email " + "gxpc-eng@google.com" + "\n" + "\n" + "  Please include the command-line arguments, full output (including the\n" + "  stack trace) and the location of your client workspace in your report.\n" + "\n" + BANNER_STRIPE + "\n";
    public static final String GXPC_LINKAGE_ERROR_BANNER = "\n" + BANNER_STRIPE + "\n" + "\n" + "  Looks like there's something wrong with your client workspace!\n" + "  Try doing a clean build.\n" + "\n" + "  If the problem persists, feel free to contact " + "gxpc-eng@google.com" + "\n" + "  for assistance.\n" + "\n" + BANNER_STRIPE + "\n";

    public static void main(String[] args) throws IOException {
        SystemFileSystem sysFs = SystemFileSystem.INSTANCE;
        FileRef cwd = sysFs.parseFilename(System.getProperty("user.dir"));
        int result = Gxpc.main(sysFs, System.err, cwd, args);
        System.exit(result);
    }

    static int main(FileSystem fs, Appendable stderr, FileRef cwd, String ... args) throws IOException {
        try {
            GxpcFlags config = new GxpcFlags(fs, cwd, args);
            if (config.showHelp()) {
                config.printHelp(stderr);
                return 0;
            }
            if (config.getSourceFiles().isEmpty()) {
                stderr.append("gxpc: no input files\n");
                return 1;
            }
            PrintingAlertSink alertSink = new PrintingAlertSink(config.getAlertPolicy(), config.isVerboseEnabled(), stderr);
            AlertCounter counter = new AlertCounter(alertSink, config.getAlertPolicy());
            new Compiler(config).call(counter);
            return counter.getErrorCount() > 0 ? 1 : 0;
        }
        catch (CmdLineException usageError) {
            stderr.append(usageError.getMessage() + "\n");
            return 1;
        }
        catch (InvalidConfigException invalidConfigException) {
            stderr.append(invalidConfigException.getMessage() + "\n");
            return 1;
        }
        catch (LinkageError linkageError) {
            stderr.append(GXPC_LINKAGE_ERROR_BANNER);
            return -1;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            stderr.append(GXPC_BUG_BANNER);
            return -1;
        }
    }

    private static String makeStripe(int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append('*');
        }
        return sb.toString();
    }
}

