/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Assert;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.exception.ExpressionLanguageNotAvailableException;
import net.sf.oval.expression.ExpressionLanguage;

public class AssertCheck
extends AbstractAnnotationCheck<Assert> {
    private static final long serialVersionUID = 1L;
    private String expr;
    private String lang;

    @Override
    public void configure(Assert constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setExpr(constraintAnnotation.expr());
        this.setLang(constraintAnnotation.lang());
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("expression", this.expr);
        messageVariables.put("language", this.lang);
        return messageVariables;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) throws ExpressionEvaluationException, ExpressionLanguageNotAvailableException {
        Map values = Validator.getCollectionFactory().createMap();
        values.put("_value", valueToValidate);
        values.put("_this", validatedObject);
        ExpressionLanguage el = cycle.getValidator().getExpressionLanguageRegistry().getExpressionLanguage(this.lang);
        return el.evaluateAsBoolean(this.expr, values);
    }

    public void setExpr(String expression) {
        this.expr = expression;
        this.requireMessageVariablesRecreation();
    }

    public void setLang(String language) {
        this.lang = language;
        this.requireMessageVariablesRecreation();
    }
}

